/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.web.servlets.AbstractMyrrixServlet;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.common.NoSuchItemException;
import org.apache.mahout.cf.taste.common.NoSuchUserException;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.WeightedRunningAverage;

public final class PreferenceServlet
extends AbstractMyrrixServlet {
    public static final String AVG_ESTIMATE_ERROR_KEY = PreferenceServlet.class.getName() + ".AVG_ESTIMATE_ERROR";
    private WeightedRunningAverage avgEstimateError;

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.avgEstimateError = new WeightedRunningAverage();
        config.getServletContext().setAttribute(AVG_ESTIMATE_ERROR_KEY, (Object)this.avgEstimateError);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        float prefValue;
        long itemID;
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
            itemID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        if (pathComponents.hasNext()) {
            response.sendError(400, "Path too long");
            return;
        }
        try {
            prefValue = PreferenceServlet.readValue((ServletRequest)request);
        }
        catch (IllegalArgumentException iae) {
            response.sendError(400, "Bad value");
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            if (prefValue > 0.0f) {
                try {
                    float estimate = recommender.estimatePreference(userID, itemID);
                    this.avgEstimateError.addDatum(FastMath.max((double)0.0, (double)(1.0 - (double)estimate)), (double)prefValue);
                }
                catch (NoSuchUserException nsue) {
                }
                catch (NoSuchItemException nsie) {
                }
                catch (NotReadyException nre) {
                    // empty catch block
                }
            }
            recommender.setPreference(userID, itemID, prefValue);
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws IOException {
        long itemID;
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
            itemID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            response.sendError(400, nsee.toString());
            return;
        }
        catch (NumberFormatException nfe) {
            response.sendError(400, nfe.toString());
            return;
        }
        MyrrixRecommender recommender = this.getRecommender();
        try {
            recommender.removePreference(userID, itemID);
        }
        catch (TasteException te) {
            response.sendError(500, te.toString());
            this.getServletContext().log("Unexpected error in " + ((Object)((Object)this)).getClass().getSimpleName(), (Throwable)te);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static float readValue(ServletRequest request) throws IOException {
        String line;
        BufferedReader reader = request.getReader();
        try {
            line = reader.readLine();
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)true);
        }
        if (line == null || line.isEmpty()) {
            return 1.0f;
        }
        return LangUtils.parseFloat((String)line);
    }

    @Override
    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        long userID;
        String pathInfo = request.getPathInfo();
        Iterator pathComponents = SLASH.split((CharSequence)pathInfo).iterator();
        try {
            userID = Long.parseLong((String)pathComponents.next());
        }
        catch (NoSuchElementException nsee) {
            return null;
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        return userID;
    }
}

