/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.servlets;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Maps;
import com.google.common.net.HostAndPort;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.ReloadingReference;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.random.RandomUtils;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.common.stats.ServletStats;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public abstract class AbstractMyrrixServlet
extends HttpServlet {
    private static final Splitter COMMA = Splitter.on((char)',').omitEmptyStrings().trimResults();
    static final Splitter SLASH = Splitter.on((char)'/').omitEmptyStrings();
    static final int DEFAULT_HOW_MANY = 10;
    private static final String KEY_PREFIX = AbstractMyrrixServlet.class.getName();
    public static final String READ_ONLY_KEY = KEY_PREFIX + ".READ_ONLY";
    public static final String RECOMMENDER_KEY = KEY_PREFIX + ".RECOMMENDER";
    public static final String RESCORER_PROVIDER_KEY = KEY_PREFIX + ".RESCORER_PROVIDER";
    public static final String TIMINGS_KEY = KEY_PREFIX + ".TIMINGS";
    public static final String LOCAL_INPUT_DIR_KEY = KEY_PREFIX + ".LOCAL_INPUT_DIR";
    public static final String ALL_PARTITIONS_REF_KEY = KEY_PREFIX + ".ALL_PARTITIONS";
    public static final String PARTITION_KEY = KEY_PREFIX + ".PARTITION";
    private static final String[] NO_PARAMS = new String[0];
    private MyrrixRecommender recommender;
    private RescorerProvider rescorerProvider;
    private ServletStats timing;
    private ReloadingReference<List<List<HostAndPort>>> allPartitions;
    private int thisPartition;
    private ConcurrentMap<String, ResponseContentType> responseTypeCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(ServletConfig config) throws ServletException {
        Map timings;
        ReloadingReference theAllPartitions;
        super.init(config);
        ServletContext context = config.getServletContext();
        this.recommender = (MyrrixRecommender)context.getAttribute(RECOMMENDER_KEY);
        this.rescorerProvider = (RescorerProvider)context.getAttribute(RESCORER_PROVIDER_KEY);
        this.allPartitions = theAllPartitions = (ReloadingReference)context.getAttribute(ALL_PARTITIONS_REF_KEY);
        this.thisPartition = (Integer)context.getAttribute(PARTITION_KEY);
        this.responseTypeCache = Maps.newConcurrentMap();
        ServletContext servletContext = context;
        synchronized (servletContext) {
            timings = (Map)context.getAttribute(TIMINGS_KEY);
            if (timings == null) {
                timings = Maps.newTreeMap();
                context.setAttribute(TIMINGS_KEY, (Object)timings);
            }
        }
        String key = ((Object)((Object)this)).getClass().getSimpleName();
        ServletStats theTiming = (ServletStats)timings.get(key);
        if (theTiming == null) {
            theTiming = new ServletStats();
            timings.put(key, theTiming);
        }
        this.timing = theTiming;
    }

    protected final void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.allPartitions != null) {
            int partitionToServe;
            List thePartitions = (List)this.allPartitions.get(1L, TimeUnit.SECONDS);
            Long unnormalizedPartitionToServe = this.getUnnormalizedPartitionToServe(request);
            if (unnormalizedPartitionToServe != null && (partitionToServe = LangUtils.mod((long)unnormalizedPartitionToServe, (int)thePartitions.size())) != this.thisPartition) {
                String redirectURL = AbstractMyrrixServlet.buildRedirectToPartitionURL(request, partitionToServe, unnormalizedPartitionToServe, thePartitions);
                response.sendRedirect(redirectURL);
                return;
            }
        }
        long start = System.nanoTime();
        super.service(request, response);
        this.timing.addTiming(System.nanoTime() - start);
        int status = response.getStatus();
        if (status >= 400) {
            if (status >= 500) {
                this.timing.incrementServerErrors();
            } else {
                this.timing.incrementClientErrors();
            }
        }
    }

    private static String buildRedirectToPartitionURL(HttpServletRequest request, int toPartition, long unnormalizedPartitionToServe, List<List<HostAndPort>> thePartitions) {
        List<HostAndPort> replicas = thePartitions.get(toPartition);
        int chosenReplica = LangUtils.mod((long)RandomUtils.md5HashToLong((long)unnormalizedPartitionToServe), (int)replicas.size());
        HostAndPort hostPort = replicas.get(chosenReplica);
        StringBuilder redirectURL = new StringBuilder();
        redirectURL.append(request.isSecure() ? "https" : "http").append("://");
        redirectURL.append(hostPort.getHostText()).append(':').append(hostPort.getPort());
        redirectURL.append(request.getRequestURI());
        String query = request.getQueryString();
        if (query != null) {
            redirectURL.append('?').append(query);
        }
        return redirectURL.toString();
    }

    protected Long getUnnormalizedPartitionToServe(HttpServletRequest request) {
        return null;
    }

    protected final MyrrixRecommender getRecommender() {
        return this.recommender;
    }

    protected final RescorerProvider getRescorerProvider() {
        return this.rescorerProvider;
    }

    public final ServletStats getTiming() {
        return this.timing;
    }

    protected static int getHowMany(ServletRequest request) {
        String howManyString = request.getParameter("howMany");
        if (howManyString == null) {
            return 10;
        }
        int howMany = Integer.parseInt(howManyString);
        Preconditions.checkArgument((howMany > 0 ? 1 : 0) != 0, (Object)"howMany must be positive");
        return howMany;
    }

    protected static String[] getRescorerParams(ServletRequest request) {
        String[] rescorerParams = request.getParameterValues("rescorerParams");
        return rescorerParams == null ? NO_PARAMS : rescorerParams;
    }

    protected static boolean getConsiderKnownItems(ServletRequest request) {
        return Boolean.valueOf(request.getParameter("considerKnownItems"));
    }

    protected final void output(HttpServletRequest request, ServletResponse response, Iterable<RecommendedItem> items) throws IOException {
        PrintWriter writer = response.getWriter();
        switch (this.determineResponseType(request)) {
            case JSON: {
                writer.write(91);
                boolean first = true;
                for (RecommendedItem item : items) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    writer.write(91);
                    writer.write(Long.toString(item.getItemID()));
                    writer.write(44);
                    writer.write(Float.toString(item.getValue()));
                    writer.write(93);
                }
                writer.write(93);
                break;
            }
            case CSV: {
                for (RecommendedItem item : items) {
                    writer.write(Long.toString(item.getItemID()));
                    writer.write(44);
                    writer.write(Float.toString(item.getValue()));
                    writer.write(10);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown response type");
            }
        }
    }

    final ResponseContentType determineResponseType(HttpServletRequest request) {
        String acceptHeader = request.getHeader("Accept");
        if (acceptHeader == null) {
            return ResponseContentType.JSON;
        }
        ResponseContentType cached = (ResponseContentType)((Object)this.responseTypeCache.get(acceptHeader));
        if (cached != null) {
            return cached;
        }
        TreeMap types = Maps.newTreeMap();
        for (String accept : COMMA.split((CharSequence)acceptHeader)) {
            String type;
            double preference;
            int semiColon = accept.indexOf(59);
            if (semiColon < 0) {
                preference = 1.0;
                type = accept;
            } else {
                String valueString = accept.substring(semiColon + 1).trim();
                if (valueString.startsWith("q=")) {
                    valueString = valueString.substring(2);
                }
                try {
                    preference = LangUtils.parseDouble((String)valueString);
                }
                catch (IllegalArgumentException iae) {
                    preference = 1.0;
                }
                type = accept.substring(semiColon);
            }
            ResponseContentType parsedType = null;
            if ("text/csv".equals(type) || "text/plain".equals(type)) {
                parsedType = ResponseContentType.CSV;
            } else if ("application/json".equals(type)) {
                parsedType = ResponseContentType.JSON;
            }
            if (parsedType == null) continue;
            types.put(preference, parsedType);
        }
        ResponseContentType finalType = types.isEmpty() ? ResponseContentType.JSON : (ResponseContentType)((Object)types.values().iterator().next());
        this.responseTypeCache.putIfAbsent(acceptHeader, finalType);
        return finalType;
    }

    final void outputIDs(HttpServletRequest request, ServletResponse response, FastIDSet ids) throws IOException {
        PrintWriter writer = response.getWriter();
        LongPrimitiveIterator it = ids.iterator();
        switch (this.determineResponseType(request)) {
            case JSON: {
                writer.write(91);
                boolean first = true;
                while (it.hasNext()) {
                    if (first) {
                        first = false;
                    } else {
                        writer.write(44);
                    }
                    writer.write(Long.toString(it.nextLong()));
                }
                writer.write(93);
                break;
            }
            case CSV: {
                while (it.hasNext()) {
                    writer.write(Long.toString(it.nextLong()));
                    writer.write(10);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown response type");
            }
        }
    }

    static enum ResponseContentType {
        JSON,
        CSV;

    }
}

