/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web.common.stats;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.myrrix.common.stats.RunningStatistics;
import net.myrrix.common.stats.RunningStatisticsPerTime;

public final class ServletStats
implements Serializable {
    private final RunningStatistics allTime = new RunningStatistics();
    private final RunningStatisticsPerTime lastHour = new RunningStatisticsPerTime(TimeUnit.HOURS);
    private final AtomicInteger numClientErrors = new AtomicInteger();
    private final AtomicInteger numServerErrors = new AtomicInteger();

    public void addTiming(long value) {
        this.allTime.addDatum((double)value);
        this.lastHour.addDatum((double)value);
    }

    public RunningStatistics getAllTime() {
        return this.allTime;
    }

    public RunningStatisticsPerTime getLastHour() {
        return this.lastHour;
    }

    public int getNumClientErrors() {
        return this.numClientErrors.get();
    }

    public void incrementClientErrors() {
        this.numClientErrors.incrementAndGet();
    }

    public int getNumServerErrors() {
        return this.numServerErrors.get();
    }

    public void incrementServerErrors() {
        this.numServerErrors.incrementAndGet();
    }
}

