/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.lexicalscope.jewel.cli.Option;
import java.io.File;

public interface RunnerArgs {
    @Option(defaultToNull=true, description="Working directory for input and intermediate files")
    public File getLocalInputDir();

    @Option(defaultToNull=true, description="Bucket storing data to access")
    public String getBucket();

    @Option(defaultToNull=true, description="Instance ID to access")
    public String getInstanceID();

    @Option(defaultValue={"80"}, description="HTTP port number")
    public int getPort();

    @Option(defaultValue={"443"}, description="HTTPS port number")
    public int getSecurePort();

    @Option(defaultToNull=true, description="Non-root context path to deploy endpoints under")
    public String getContextPath();

    @Option(description="Disables all API methods that add or change data")
    public boolean isReadOnly();

    @Option(defaultToNull=true, description="User name needed to authenticate to this instance")
    public String getUserName();

    @Option(defaultToNull=true, description="Password to authenticate to this instance")
    public String getPassword();

    @Option(description="User name and password only apply to admin and console resources")
    public boolean isConsoleOnlyPassword();

    @Option(defaultToNull=true, description="Test SSL certificate keystore to accept")
    public File getKeystoreFile();

    @Option(defaultToNull=true, description="Password for keystoreFile")
    public String getKeystorePassword();

    @Option(defaultToNull=true, description="Max number of requests per minute from a host before it is temporarily blocked")
    public Integer getHostRequestLimit();

    @Option(defaultToNull=true, description="RescorerProvider implementation class")
    public String getRescorerProviderClass();

    @Option(defaultToNull=true, description="ClientThread implementation class")
    public String getClientThreadClass();

    @Option(defaultToNull=true, description="All partitions, as comma-separated host:port (e.g. foo1:8080,foo2:80,bar1:8081), or \"auto\" (distributed mode only)")
    public String getAllPartitions();

    @Option(defaultToNull=true, description="Server's partition number (0-based)")
    public Integer getPartition();

    @Option(defaultToNull=true, description="License key file [subject].lic")
    public File getLicenseFile();

    @Option(helpRequest=true)
    public boolean getHelp();
}

