/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import net.myrrix.common.ExecutorUtils;

public final class DoSFilter
implements Filter {
    public static final String MAX_ACCESS_PER_HOST_PER_MIN_KEY = "maxAccessPerHostPerMin";
    private static final int DEFAULT_MAX_ACCESS_PER_HOST_PER_MIN = 1000;
    private final Map<String, AtomicInteger> numRecentAccesses = Collections.synchronizedMap(Maps.newHashMap());
    private final Set<String> bannedIPAddresses = Collections.synchronizedSet(Sets.newHashSet());
    private int maxAccessPerHostPerMin;
    private ScheduledExecutorService executor;

    public void init(FilterConfig filterConfig) {
        String maxAccessPerHostPerMinString = filterConfig.getInitParameter(MAX_ACCESS_PER_HOST_PER_MIN_KEY);
        this.maxAccessPerHostPerMin = maxAccessPerHostPerMinString == null ? 1000 : Integer.parseInt(maxAccessPerHostPerMinString);
        Preconditions.checkArgument((this.maxAccessPerHostPerMin > 0 ? 1 : 0) != 0);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DoSFilter.this.numRecentAccesses.clear();
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                DoSFilter.this.bannedIPAddresses.clear();
            }
        }, 1L, 1L, TimeUnit.HOURS);
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.isBanned(request)) {
            HttpServletResponse servletResponse = (HttpServletResponse)response;
            servletResponse.sendError(403);
        } else {
            chain.doFilter(request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isBanned(ServletRequest request) {
        AtomicInteger count;
        String remoteIPAddressString = request.getRemoteAddr();
        if (this.bannedIPAddresses.contains(remoteIPAddressString)) {
            return true;
        }
        Map<String, AtomicInteger> map = this.numRecentAccesses;
        synchronized (map) {
            count = this.numRecentAccesses.get(remoteIPAddressString);
            if (count == null) {
                count = new AtomicInteger(0);
                this.numRecentAccesses.put(remoteIPAddressString, count);
            }
        }
        if (count.incrementAndGet() > this.maxAccessPerHostPerMin) {
            this.bannedIPAddresses.add(remoteIPAddressString);
            return true;
        }
        return false;
    }

    public void destroy() {
        ExecutorUtils.shutdownNowAndAwait((ExecutorService)this.executor);
        this.numRecentAccesses.clear();
        this.bannedIPAddresses.clear();
    }
}

