/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.online.RescorerProvider;
import net.myrrix.online.ServerRecommender;
import net.myrrix.web.AllConfig;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;

public final class AllItemSimilarities
implements Callable<Object> {
    private final AllConfig config;

    public AllItemSimilarities(AllConfig config) {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
    }

    public static void main(String[] args) throws Exception {
        AllConfig config = AllConfig.build(args);
        if (config != null) {
            new AllItemSimilarities(config).call();
        }
    }

    @Override
    public Object call() throws InterruptedException, NotReadyException, ExecutionException {
        final ServerRecommender recommender = new ServerRecommender(this.config.getLocalInputDir());
        recommender.await();
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new ThreadFactoryBuilder().setNameFormat("AllItemSimilarities-%d").build());
        ArrayList futures = Lists.newArrayList();
        final RescorerProvider rescorerProvider = this.config.getRescorerProvider();
        final int howMany = this.config.getHowMany();
        final PrintStream out = System.out;
        LongPrimitiveIterator it = recommender.getAllItemIDs().iterator();
        while (it.hasNext()) {
            final long itemID = it.nextLong();
            futures.add(executorService.submit(new Callable<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void call() throws Exception {
                    Rescorer rescorer = rescorerProvider == null ? null : rescorerProvider.getMostSimilarItemsRescorer((MyrrixRecommender)recommender, new String[0]);
                    List similar = recommender.mostSimilarItems(new long[]{itemID}, howMany, rescorer);
                    StringBuilder line = new StringBuilder(30);
                    PrintStream printStream = out;
                    synchronized (printStream) {
                        out.println(Long.toString(itemID));
                        for (RecommendedItem sim : similar) {
                            line.setLength(0);
                            line.append(Long.toString(sim.getItemID())).append(',').append(Float.toString(sim.getValue()));
                            out.println(line);
                        }
                    }
                    return null;
                }
            }));
        }
        executorService.shutdown();
        for (Future future : futures) {
            future.get();
        }
        return null;
    }
}

