/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.web;

import com.google.common.base.Preconditions;
import com.lexicalscope.jewel.cli.ArgumentValidationException;
import com.lexicalscope.jewel.cli.CliFactory;
import java.io.File;
import net.myrrix.online.AbstractRescorerProvider;
import net.myrrix.online.RescorerProvider;
import net.myrrix.web.AllUtilityArgs;

public final class AllConfig {
    private final File localInputDir;
    private final RescorerProvider rescorerProvider;
    private final int howMany;

    public AllConfig(File localInputDir, RescorerProvider rescorerProvider, int howMany) {
        Preconditions.checkNotNull((Object)localInputDir);
        Preconditions.checkArgument((howMany > 0 ? 1 : 0) != 0, (String)"howMany must be positive: %s", (Object[])new Object[]{howMany});
        this.localInputDir = localInputDir;
        this.rescorerProvider = rescorerProvider;
        this.howMany = howMany;
    }

    public File getLocalInputDir() {
        return this.localInputDir;
    }

    public RescorerProvider getRescorerProvider() {
        return this.rescorerProvider;
    }

    public int getHowMany() {
        return this.howMany;
    }

    static AllConfig build(String[] args) {
        AllUtilityArgs allArgs;
        try {
            allArgs = (AllUtilityArgs)CliFactory.parseArguments(AllUtilityArgs.class, (String[])args);
        }
        catch (ArgumentValidationException ave) {
            System.out.println();
            System.out.println(ave.getMessage());
            System.out.println();
            return null;
        }
        String rescorerProviderClassNames = allArgs.getRescorerProviderClass();
        RescorerProvider rescorerProvider = rescorerProviderClassNames == null ? null : AbstractRescorerProvider.loadRescorerProviders((String)rescorerProviderClassNames, null);
        return new AllConfig(allArgs.getLocalInputDir(), rescorerProvider, allArgs.getHowMany());
    }
}

