/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Writer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import net.myrrix.common.OneWayMigrator;
import net.myrrix.common.ReloadingReference;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.math.SingularMatrixSolverException;
import net.myrrix.common.math.SolverException;
import net.myrrix.common.parallel.ExecutorUtils;
import net.myrrix.online.factorizer.MatrixFactorizer;
import net.myrrix.online.factorizer.als.AlternatingLeastSquares;
import net.myrrix.online.generation.Generation;
import net.myrrix.online.generation.GenerationLoader;
import net.myrrix.online.generation.GenerationManager;
import net.myrrix.online.generation.GenerationSerializer;
import net.myrrix.online.generation.InputFilesReader;
import org.apache.mahout.cf.taste.model.IDMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DelegateGenerationManager
implements GenerationManager {
    private static final Logger log = LoggerFactory.getLogger(DelegateGenerationManager.class);
    private static final int WRITES_BETWEEN_REBUILD = Integer.parseInt(System.getProperty("model.local.writesBetweenRebuild", "100000"));
    private final File inputDir;
    private final File modelFile;
    private final File appendFile;
    private Writer appender;
    private Generation currentGeneration;
    private final FastIDSet recentlyActiveUsers;
    private final FastIDSet recentlyActiveItems;
    private final IDMigrator hasher;
    private final GenerationLoader loader;
    private int countdownToRebuild;
    private final ExecutorService refreshExecutor;
    private final Semaphore refreshSemaphore;

    public DelegateGenerationManager(File localInputDir) throws IOException {
        this(null, null, localInputDir, 0, null);
    }

    public DelegateGenerationManager(String bucket, String instanceID, File localInputDir, int partition, ReloadingReference<List<?>> allPartitions) throws IOException {
        log.info("Using local computation, and data in {}", (Object)localInputDir);
        this.inputDir = localInputDir;
        if (!this.inputDir.exists() || !this.inputDir.isDirectory()) {
            throw new FileNotFoundException(this.inputDir.toString());
        }
        this.modelFile = new File(this.inputDir, "model.bin.gz");
        this.appendFile = new File(this.inputDir, "append.bin.gz");
        this.recentlyActiveUsers = new FastIDSet();
        this.recentlyActiveItems = new FastIDSet();
        this.hasher = new OneWayMigrator();
        this.loader = new GenerationLoader(this.recentlyActiveUsers, this.recentlyActiveItems, this);
        this.countdownToRebuild = WRITES_BETWEEN_REBUILD;
        this.refreshExecutor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("LocalGenerationManager-%d").build());
        this.refreshSemaphore = new Semaphore(1);
        this.refresh();
    }

    public String getBucket() {
        return null;
    }

    public String getInstanceID() {
        return null;
    }

    public void append(long userID, long itemID, float value, boolean bulk) throws IOException {
        StringBuilder line = new StringBuilder(32);
        line.append(userID).append(',').append(itemID).append(',').append(value).append('\n');
        this.doAppend(line, userID, itemID, bulk);
    }

    public void appendUserTag(long userID, String tag, float value, boolean bulk) throws IOException {
        StringBuilder line = new StringBuilder(32);
        line.append(userID).append(",\"").append(tag).append("\",").append(value).append('\n');
        long itemID = this.hasher.toLongID(tag);
        this.doAppend(line, userID, itemID, bulk);
    }

    public void appendItemTag(String tag, long itemID, float value, boolean bulk) throws IOException {
        StringBuilder line = new StringBuilder(32);
        line.append('\"').append(tag).append("\",").append(itemID).append(',').append(value).append('\n');
        long userID = this.hasher.toLongID(tag);
        this.doAppend(line, userID, itemID, bulk);
    }

    public void remove(long userID, long itemID, boolean bulk) throws IOException {
        StringBuilder line = new StringBuilder(32);
        line.append(userID).append(',').append(itemID).append(",\n");
        this.doAppend(line, userID, itemID, bulk);
    }

    private synchronized void doAppend(CharSequence line, long userID, long itemID, boolean bulk) throws IOException {
        if (this.appender != null) {
            this.appender.append(line);
        }
        this.recentlyActiveUsers.add(userID);
        this.recentlyActiveItems.add(itemID);
        this.maybeRefresh(bulk);
    }

    public synchronized void bulkDone() throws IOException {
        this.appender.flush();
        this.maybeRefresh(false);
    }

    private synchronized void maybeRefresh(boolean bulk) {
        if (--this.countdownToRebuild <= 0 && !bulk) {
            this.countdownToRebuild = WRITES_BETWEEN_REBUILD;
            this.refresh();
        }
    }

    private synchronized void closeAppender() throws IOException {
        if (this.appender != null) {
            try {
                this.appender.close();
            }
            catch (IOException ioe) {
                log.warn("Failed to close appender cleanly", (Throwable)ioe);
            }
            if (this.appendFile.exists()) {
                if (IOUtils.isGZIPFileEmpty((File)this.appendFile)) {
                    log.info("File appears to have no data, deleting: {}", (Object)this.appendFile);
                    if (!this.appendFile.delete()) {
                        log.warn("Could not delete {}", (Object)this.appendFile);
                    }
                } else {
                    Files.move((File)this.appendFile, (File)new File(this.inputDir, System.currentTimeMillis() + ".csv.gz"));
                }
            }
        }
    }

    public void close() throws IOException {
        ExecutorUtils.shutdownNowAndAwait((ExecutorService)this.refreshExecutor);
        this.closeAppender();
    }

    public synchronized void refresh() {
        try {
            if (this.appender != null) {
                this.appender.flush();
            }
        }
        catch (IOException e) {
            log.warn("Exception while flushing", (Throwable)e);
        }
        if (this.refreshSemaphore.tryAcquire()) {
            this.refreshExecutor.submit(new RefreshCallable());
        } else {
            log.info("Refresh already in progress");
        }
    }

    public Generation getCurrentGeneration() {
        return this.currentGeneration;
    }

    private Generation readModel() throws IOException {
        log.info("Reading model from {}", (Object)this.modelFile);
        try {
            return GenerationSerializer.readGeneration(this.modelFile);
        }
        catch (ObjectStreamException ose) {
            log.warn("Model file was not readable, rebuilding", (Throwable)ose);
            return null;
        }
    }

    private static void saveModel(Generation generation, File modelFile) throws IOException {
        File newModelFile = File.createTempFile(DelegateGenerationManager.class.getSimpleName(), ".bin.gz");
        log.info("Writing model to {}", (Object)newModelFile);
        try {
            GenerationSerializer.writeGeneration(generation, newModelFile);
        }
        catch (IOException ioe) {
            if (newModelFile.exists() && !newModelFile.delete()) {
                log.warn("Could not delete {}", (Object)newModelFile);
            }
            throw ioe;
        }
        log.info("Done, moving into place at {}", (Object)modelFile);
        if (modelFile.exists() && !modelFile.delete()) {
            log.warn("Could not delete old {}", (Object)modelFile);
        }
        Files.move((File)newModelFile, (File)modelFile);
    }

    static {
        Preconditions.checkArgument((WRITES_BETWEEN_REBUILD > 0 ? 1 : 0) != 0, (String)"Bad model.local.writesBetweenRebuild: %s", (Object[])new Object[]{WRITES_BETWEEN_REBUILD});
    }

    private final class RefreshCallable
    implements Callable<Void> {
        private RefreshCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() {
            try {
                DelegateGenerationManager delegateGenerationManager = DelegateGenerationManager.this;
                synchronized (delegateGenerationManager) {
                    DelegateGenerationManager.this.closeAppender();
                    DelegateGenerationManager.this.appender = IOUtils.buildGZIPWriter((File)DelegateGenerationManager.this.appendFile);
                }
                try {
                    Generation theCurrentGeneration;
                    if (DelegateGenerationManager.this.currentGeneration == null && DelegateGenerationManager.this.modelFile.exists()) {
                        DelegateGenerationManager.this.currentGeneration = DelegateGenerationManager.this.readModel();
                    }
                    if ((theCurrentGeneration = DelegateGenerationManager.this.currentGeneration) == null) {
                        FastByIDMap newKnownItemsIDs = Boolean.valueOf(System.getProperty("model.noKnownItems")) != false ? null : new FastByIDMap(10000, 1.25f);
                        theCurrentGeneration = new Generation(newKnownItemsIDs, new FastByIDMap(10000, 1.25f), new FastByIDMap(10000, 1.25f), new FastIDSet(1000, 1.25f), new FastIDSet(1000, 1.25f));
                    }
                    log.info("Computing model from input in {}", (Object)DelegateGenerationManager.this.inputDir);
                    FastByIDMap knownItemIDs = Boolean.valueOf(System.getProperty("model.noKnownItems")) != false ? null : new FastByIDMap(10000, 1.25f);
                    FastByIDMap RbyRow = new FastByIDMap(10000, 1.25f);
                    FastByIDMap RbyColumn = new FastByIDMap(10000, 1.25f);
                    FastIDSet itemTagIDs = new FastIDSet(1000, 1.25f);
                    FastIDSet userTagIDs = new FastIDSet(1000, 1.25f);
                    InputFilesReader.readInputFiles((FastByIDMap<FastIDSet>)knownItemIDs, (FastByIDMap<FastByIDFloatMap>)RbyRow, (FastByIDMap<FastByIDFloatMap>)RbyColumn, itemTagIDs, userTagIDs, DelegateGenerationManager.this.inputDir);
                    if (!RbyRow.isEmpty() && !RbyColumn.isEmpty()) {
                        Generation latestGeneration;
                        MatrixFactorizer als;
                        while (true) {
                            try {
                                als = this.runFactorization(theCurrentGeneration, (FastByIDMap<FastByIDFloatMap>)RbyRow, (FastByIDMap<FastByIDFloatMap>)RbyColumn);
                                latestGeneration = new Generation(knownItemIDs, als.getX(), als.getY(), itemTagIDs, userTagIDs);
                            }
                            catch (SingularMatrixSolverException smse) {
                                int currentFeatures = this.readNumFeatures();
                                int fewerFeatures = smse.getApparentRank();
                                if (fewerFeatures <= 1) {
                                    throw smse;
                                }
                                log.warn("Could not build model with {} features; setting model.features down to {}", (Object)currentFeatures, (Object)fewerFeatures);
                                System.setProperty("model.features", Integer.toString(fewerFeatures));
                                continue;
                            }
                            break;
                        }
                        DelegateGenerationManager.saveModel(latestGeneration, DelegateGenerationManager.this.modelFile);
                        DelegateGenerationManager.this.loader.loadModel(theCurrentGeneration, (FastByIDMap<float[]>)als.getX(), (FastByIDMap<float[]>)als.getY(), (FastByIDMap<FastIDSet>)knownItemIDs, itemTagIDs, userTagIDs);
                    }
                    int numItems = theCurrentGeneration.getNumItems();
                    int numUsers = theCurrentGeneration.getNumUsers();
                    if (numUsers == 0 || numItems == 0) {
                        log.warn("Model has no users, or no items ({}, {}); ignoring", (Object)numUsers, (Object)numItems);
                    } else {
                        DelegateGenerationManager.this.currentGeneration = theCurrentGeneration;
                    }
                }
                catch (OutOfMemoryError oome) {
                    log.warn("Increase heap size with -Xmx, decrease new generation size with larger -XX:NewRatio value, and/or use -XX:+UseCompressedOops");
                    DelegateGenerationManager.this.currentGeneration = null;
                    throw oome;
                }
                catch (SolverException ignored) {
                    log.warn("Unable to compute a valid generation yet; waiting for more data");
                    DelegateGenerationManager.this.currentGeneration = null;
                }
            }
            catch (Throwable t) {
                log.warn("Unexpected exception while refreshing", t);
            }
            finally {
                DelegateGenerationManager.this.refreshSemaphore.release();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private MatrixFactorizer runFactorization(Generation currentGeneration, FastByIDMap<FastByIDFloatMap> rbyRow, FastByIDMap<FastByIDFloatMap> rbyColumn) throws IOException {
            FastByIDMap previousY;
            log.info("Building factorization...");
            int features = this.readNumFeatures();
            if (System.getProperty("model.iterations") != null) {
                log.warn("model.iterations system property is deprecated and ignored; use model.als.iterations.convergenceThreshold");
            }
            String iterationsConvergenceString = System.getProperty("model.als.iterations.convergenceThreshold", Double.toString(0.001));
            String maxIterationsString = System.getProperty("model.iterations.max", Integer.toString(30));
            AlternatingLeastSquares als = new AlternatingLeastSquares(rbyRow, rbyColumn, features, Double.parseDouble(iterationsConvergenceString), Integer.parseInt(maxIterationsString));
            if (currentGeneration != null && (previousY = currentGeneration.getY()) != null) {
                FastByIDMap previousYClone;
                Lock yLock = currentGeneration.getYLock().readLock();
                yLock.lock();
                try {
                    previousYClone = new FastByIDMap(previousY.size());
                    for (FastByIDMap.MapEntry entry : previousY.entrySet()) {
                        previousYClone.put(entry.getKey(), ((float[])entry.getValue()).clone());
                    }
                }
                finally {
                    yLock.unlock();
                }
                als.setPreviousY(previousYClone);
            }
            try {
                als.call();
                log.info("Factorization complete");
            }
            catch (ExecutionException ee) {
                throw new IOException(ee.getCause());
            }
            catch (InterruptedException ignored) {
                log.warn("ALS computation was interrupted");
            }
            return als;
        }

        private int readNumFeatures() {
            String featuresString = System.getProperty("model.features");
            return featuresString == null ? 30 : Integer.parseInt(featuresString);
        }
    }
}

