/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.online.generation;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.online.generation.Generation;
import net.myrrix.online.generation.GenerationSerializer;
import net.myrrix.online.generation.InputFilesReader;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UnreducedModel {
    private static final Logger log = LoggerFactory.getLogger(UnreducedModel.class);

    private UnreducedModel() {
    }

    public static void main(String[] args) throws Exception {
        File inputDir = new File(args[0]);
        UnreducedModel.writeUnreducedModel(inputDir);
    }

    public static void writeUnreducedModel(File inputDir) throws IOException {
        FastByIDMap<float[]> Y;
        FastByIDMap<float[]> X;
        long[] idsInOrder;
        Preconditions.checkNotNull((Object)inputDir);
        Preconditions.checkArgument((boolean)inputDir.exists());
        Preconditions.checkArgument((boolean)inputDir.isDirectory());
        FastByIDMap knownItemIDs = new FastByIDMap(10000, 1.25f);
        FastByIDMap RbyRow = new FastByIDMap(10000, 1.25f);
        FastByIDMap RbyColumn = new FastByIDMap(10000, 1.25f);
        FastIDSet itemTagIDs = new FastIDSet(1000, 1.25f);
        FastIDSet userTagIDs = new FastIDSet(1000, 1.25f);
        InputFilesReader.readInputFiles((FastByIDMap<FastIDSet>)knownItemIDs, (FastByIDMap<FastByIDFloatMap>)RbyRow, (FastByIDMap<FastByIDFloatMap>)RbyColumn, itemTagIDs, userTagIDs, inputDir);
        int numUsers = RbyRow.size();
        int numItems = RbyColumn.size();
        if (numUsers == 0 || numItems == 0) {
            log.warn("No input?");
            return;
        }
        if (numUsers < numItems) {
            log.info("{} users < {} items; input will be written as the feature-item matrix", (Object)numUsers, (Object)numItems);
            idsInOrder = UnreducedModel.idsInOrder(RbyRow);
            X = UnreducedModel.buildIdentity(idsInOrder);
            Y = UnreducedModel.buildBinarizedMatrix((FastByIDMap<FastByIDFloatMap>)RbyColumn, idsInOrder);
        } else {
            log.info("{} users >= {} items; input will be written as the user-feature matrix", (Object)numUsers, (Object)numItems);
            idsInOrder = UnreducedModel.idsInOrder(RbyColumn);
            X = UnreducedModel.buildBinarizedMatrix((FastByIDMap<FastByIDFloatMap>)RbyRow, idsInOrder);
            Y = UnreducedModel.buildIdentity(idsInOrder);
        }
        Generation generation = new Generation(knownItemIDs, X, Y, itemTagIDs, userTagIDs);
        GenerationSerializer.writeGeneration(generation, new File(inputDir, "model.bin.gz"));
    }

    private static FastByIDMap<float[]> buildIdentity(long[] idsInOrder) {
        int n = idsInOrder.length;
        FastByIDMap identity = new FastByIDMap(n);
        for (int i = 0; i < n; ++i) {
            float[] rowOrCol = new float[n];
            rowOrCol[i] = 1.0f;
            identity.put(idsInOrder[i], (Object)rowOrCol);
        }
        return identity;
    }

    private static FastByIDMap<float[]> buildBinarizedMatrix(FastByIDMap<FastByIDFloatMap> input, long[] idsInOrder) {
        int n = idsInOrder.length;
        FastByIDMap result = new FastByIDMap();
        for (FastByIDMap.MapEntry entry : input.entrySet()) {
            float[] rowOrCol = new float[n];
            FastByIDFloatMap inputValues = (FastByIDFloatMap)entry.getValue();
            for (int i = 0; i < n; ++i) {
                if (!inputValues.containsKey(idsInOrder[i])) continue;
                rowOrCol[i] = 1.0f;
            }
            result.put(entry.getKey(), (Object)rowOrCol);
        }
        return result;
    }

    private static long[] idsInOrder(FastByIDMap<?> input) {
        int n = input.size();
        long[] idsInOrder = new long[n];
        int count = 0;
        LongPrimitiveIterator it = input.keySetIterator();
        while (it.hasNext()) {
            idsInOrder[count] = it.nextLong();
            ++count;
        }
        Preconditions.checkState((n == count ? 1 : 0) != 0);
        return idsInOrder;
    }
}

