/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.stats;

import java.io.Serializable;
import org.apache.commons.math3.stat.descriptive.AbstractStorelessUnivariateStatistic;

public final class DoubleWeightedMean
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private double totalWeight;
    private double mean;

    public DoubleWeightedMean() {
        this(0.0, Double.NaN);
    }

    private DoubleWeightedMean(double totalWeight, double mean) {
        this.totalWeight = totalWeight;
        this.mean = mean;
    }

    public DoubleWeightedMean copy() {
        return new DoubleWeightedMean(this.totalWeight, this.mean);
    }

    public void clear() {
        this.totalWeight = 0.0;
        this.mean = Double.NaN;
    }

    public double getResult() {
        return this.mean;
    }

    public long getN() {
        return (long)this.totalWeight;
    }

    public void increment(double datum) {
        this.increment(datum, 1.0);
    }

    public void increment(double datum, double weight) {
        double oldTotalWeight = this.totalWeight;
        this.totalWeight += weight;
        this.mean = oldTotalWeight <= 0.0 ? datum : this.mean * oldTotalWeight / this.totalWeight + datum * weight / this.totalWeight;
    }

    public void decrement(double datum) {
        this.decrement(datum, 1.0);
    }

    public void decrement(double datum, double weight) {
        double oldTotalWeight = this.totalWeight;
        this.totalWeight -= weight;
        if (this.totalWeight <= 0.0) {
            this.clear();
        } else {
            this.mean = this.mean * oldTotalWeight / this.totalWeight - datum * weight / this.totalWeight;
        }
    }

    public String toString() {
        return Double.toString(this.mean);
    }
}

