/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.random;

import com.google.common.base.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.myrrix.common.LangUtils;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.collection.SamplingLongPrimitiveIterator;
import net.myrrix.common.math.SimpleVectorMath;
import org.apache.commons.math3.primes.Primes;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class RandomUtils {
    public static final int MAX_INT_SMALLER_TWIN_PRIME = 2147482949;
    private static final MessageDigest MD5_DIGEST;

    private RandomUtils() {
    }

    public static float[] randomUnitVector(int dimensions, RandomGenerator random) {
        float[] vector = new float[dimensions];
        RandomUtils.doRandomUnitVector(vector, random);
        return vector;
    }

    private static void doRandomUnitVector(float[] vector, RandomGenerator random) {
        int dimensions = vector.length;
        double total = 0.0;
        for (int i = 0; i < dimensions; ++i) {
            double d = random.nextGaussian();
            vector[i] = (float)d;
            total += d * d;
        }
        float normalization = (float)FastMath.sqrt((double)total);
        int i = 0;
        while (i < dimensions) {
            int n = i++;
            vector[n] = vector[n] / normalization;
        }
    }

    public static float[] randomUnitVectorFarFrom(int dimensions, List<float[]> farFrom, RandomGenerator random) {
        int size = farFrom.size();
        int numSamples = FastMath.min((int)100, (int)size);
        float[] vector = new float[dimensions];
        boolean accepted = false;
        while (!accepted) {
            RandomUtils.doRandomUnitVector(vector, random);
            double smallestDistSquared = Double.POSITIVE_INFINITY;
            for (int sample = 0; sample < numSamples; ++sample) {
                float[] other = farFrom.get(size == numSamples ? sample : random.nextInt(size));
                double distSquared = 2.0 - 2.0 * SimpleVectorMath.dot(vector, other);
                if (!LangUtils.isFinite(distSquared) || !(distSquared < smallestDistSquared)) continue;
                smallestDistSquared = distSquared;
            }
            if (LangUtils.isFinite(smallestDistSquared) && (dimensions != 1 || smallestDistSquared != 0.0)) {
                double acceptProbability = smallestDistSquared / 4.0;
                accepted = random.nextDouble() < acceptProbability;
                continue;
            }
            accepted = true;
        }
        return vector;
    }

    public static int nextTwinPrime(int n) {
        if (n > 2147482949) {
            throw new IllegalArgumentException();
        }
        if (n <= 3) {
            return 5;
        }
        int next = Primes.nextPrime((int)n);
        while (!Primes.isPrime((int)(next + 2))) {
            next = Primes.nextPrime((int)(next + 4));
        }
        return next + 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long md5HashToLong(long l) {
        byte[] hash;
        MessageDigest messageDigest = MD5_DIGEST;
        synchronized (messageDigest) {
            for (int i = 0; i < 8; ++i) {
                MD5_DIGEST.update((byte)l);
                l >>= 8;
            }
            hash = MD5_DIGEST.digest();
        }
        long result = 0L;
        for (int i = 8; i < 16; ++i) {
            result = result << 4 | (long)hash[i] & 0xFFL;
        }
        return result;
    }

    public static int randomFrom(FastIDSet set, RandomGenerator random) {
        int size = set.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Empty set");
        LongPrimitiveIterator it = set.iterator();
        it.skip(random.nextInt(size));
        return (int)it.nextLong();
    }

    public static long[] chooseAboutNFromStream(int n, LongPrimitiveIterator stream, int streamSize, RandomGenerator random) {
        Object it = n < streamSize ? new SamplingLongPrimitiveIterator(random, stream, (double)n / (double)streamSize) : stream;
        FastIDSet chosen = new FastIDSet(n);
        while (it.hasNext()) {
            chosen.add(it.nextLong());
        }
        return chosen.toArray();
    }

    static {
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

