/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import net.myrrix.common.math.Solver;
import org.apache.commons.math3.linear.ArrayRealVector;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RealVector;

final class CommonsMathSolver
implements Solver {
    private final DecompositionSolver solver;

    CommonsMathSolver(DecompositionSolver solver) {
        this.solver = solver;
    }

    @Override
    public float[] solveDToF(double[] b) {
        RealVector vec = this.solver.solve((RealVector)new ArrayRealVector(b, false));
        float[] result = new float[b.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (float)vec.getEntry(i);
        }
        return result;
    }

    @Override
    public double[] solveFToD(float[] b) {
        ArrayRealVector bVec = new ArrayRealVector(b.length);
        for (int i = 0; i < b.length; ++i) {
            bVec.setEntry(i, (double)b[i]);
        }
        RealVector vec = this.solver.solve((RealVector)bVec);
        double[] result = new double[b.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = vec.getEntry(i);
        }
        return result;
    }
}

