/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.io;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public final class Varint {
    private Varint() {
    }

    public static void writeSignedVarLong(long value, DataOutput out) throws IOException {
        Varint.writeUnsignedVarLong(value << 1 ^ value >> 63, out);
    }

    public static void writeUnsignedVarLong(long value, DataOutput out) throws IOException {
        while ((value & 0xFFFFFFFFFFFFFF80L) != 0L) {
            out.writeByte((int)value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte((int)value & 0x7F);
    }

    public static void writeSignedVarInt(int value, DataOutput out) throws IOException {
        Varint.writeUnsignedVarInt(value << 1 ^ value >> 31, out);
    }

    public static void writeUnsignedVarInt(int value, DataOutput out) throws IOException {
        while ((long)(value & 0xFFFFFF80) != 0L) {
            out.writeByte(value & 0x7F | 0x80);
            value >>>= 7;
        }
        out.writeByte(value & 0x7F);
    }

    public static long readSignedVarLong(DataInput in) throws IOException {
        long raw = Varint.readUnsignedVarLong(in);
        long temp = (raw << 63 >> 63 ^ raw) >> 1;
        return temp ^ raw & Long.MIN_VALUE;
    }

    public static long readUnsignedVarLong(DataInput in) throws IOException {
        long b;
        long value = 0L;
        int i = 0;
        while (((b = (long)in.readByte()) & 0x80L) != 0L) {
            value |= (b & 0x7FL) << i;
            Preconditions.checkArgument(((i += 7) <= 63 ? 1 : 0) != 0, (Object)"Variable length quantity is too long");
        }
        return value | b << i;
    }

    public static int readSignedVarInt(DataInput in) throws IOException {
        int raw = Varint.readUnsignedVarInt(in);
        int temp = (raw << 31 >> 31 ^ raw) >> 1;
        return temp ^ raw & Integer.MIN_VALUE;
    }

    public static int readUnsignedVarInt(DataInput in) throws IOException {
        byte b;
        int value = 0;
        int i = 0;
        while (((b = in.readByte()) & 0x80) != 0) {
            value |= (b & 0x7F) << i;
            Preconditions.checkArgument(((i += 7) <= 35 ? 1 : 0) != 0, (Object)"Variable length quantity is too long");
        }
        return value | b << i;
    }
}

