/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.collection;

import com.google.common.base.Preconditions;
import java.util.NoSuchElementException;
import net.myrrix.common.random.RandomManager;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class SamplingLongPrimitiveIterator
extends AbstractLongPrimitiveIterator {
    private final PascalDistribution geometricDistribution;
    private final LongPrimitiveIterator delegate;
    private long next;
    private boolean hasNext;

    public SamplingLongPrimitiveIterator(LongPrimitiveIterator delegate, double samplingRate) {
        this(RandomManager.getRandom(), delegate, samplingRate);
    }

    public SamplingLongPrimitiveIterator(RandomGenerator random, LongPrimitiveIterator delegate, double samplingRate) {
        Preconditions.checkNotNull((Object)random);
        Preconditions.checkNotNull((Object)delegate);
        Preconditions.checkArgument((samplingRate > 0.0 && samplingRate <= 1.0 ? 1 : 0) != 0);
        this.geometricDistribution = new PascalDistribution(random, 1, samplingRate);
        this.delegate = delegate;
        this.hasNext = true;
        this.doNext();
    }

    public boolean hasNext() {
        return this.hasNext;
    }

    public long nextLong() {
        if (this.hasNext) {
            long result = this.next;
            this.doNext();
            return result;
        }
        throw new NoSuchElementException();
    }

    public long peek() {
        if (this.hasNext) {
            return this.next;
        }
        throw new NoSuchElementException();
    }

    private void doNext() {
        int toSkip = this.geometricDistribution.sample();
        this.delegate.skip(toSkip);
        if (this.delegate.hasNext()) {
            this.next = (Long)this.delegate.next();
        } else {
            this.hasNext = false;
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void skip(int n) {
        int toSkip = 0;
        for (int i = 0; i < n; ++i) {
            toSkip += this.geometricDistribution.sample();
        }
        this.delegate.skip(toSkip);
        if (this.delegate.hasNext()) {
            this.next = (Long)this.delegate.next();
        } else {
            this.hasNext = false;
        }
    }

    public static LongPrimitiveIterator maybeWrapIterator(LongPrimitiveIterator delegate, double samplingRate) {
        return samplingRate >= 1.0 ? delegate : new SamplingLongPrimitiveIterator(delegate, samplingRate);
    }
}

