/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.stats;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;

public final class WeightedRunningAverage
implements RunningAverage,
Serializable {
    private int totalWeight = 0;
    private double average = Double.NaN;

    public synchronized void addDatum(double datum) {
        this.addDatum(datum, 1);
    }

    public synchronized void addDatum(double datum, int weight) {
        int oldTotalWeight = this.totalWeight;
        this.totalWeight += weight;
        this.average = oldTotalWeight <= 0 ? datum : this.average * (double)oldTotalWeight / (double)this.totalWeight + datum * (double)weight / (double)this.totalWeight;
    }

    public synchronized void removeDatum(double datum) {
        this.removeDatum(datum, 1);
    }

    public synchronized void removeDatum(double datum, int weight) {
        int oldTotalWeight = this.totalWeight;
        this.totalWeight -= weight;
        if (this.totalWeight <= 0) {
            this.average = Double.NaN;
            this.totalWeight = 0;
        } else {
            this.average = this.average * (double)oldTotalWeight / (double)this.totalWeight - datum * (double)weight / (double)this.totalWeight;
        }
    }

    public synchronized void changeDatum(double delta) {
        this.changeDatum(delta, 1);
    }

    public synchronized void changeDatum(double delta, int weight) {
        Preconditions.checkArgument((weight <= this.totalWeight ? 1 : 0) != 0, (String)"weight too large: %s", (Object[])new Object[]{weight});
        this.average += delta * (double)weight / (double)this.totalWeight;
    }

    public synchronized double getTotalWeight() {
        return this.totalWeight;
    }

    public synchronized int getCount() {
        return this.totalWeight;
    }

    public synchronized double getAverage() {
        return this.average;
    }

    public RunningAverage inverse() {
        throw new UnsupportedOperationException();
    }

    public synchronized String toString() {
        return Double.toString(this.average);
    }
}

