/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import net.myrrix.common.math.CommonsMathSolver;
import net.myrrix.common.math.LinearSystemSolver;
import net.myrrix.common.math.SingularMatrixSolverException;
import net.myrrix.common.math.Solver;
import org.apache.commons.math3.linear.DecompositionSolver;
import org.apache.commons.math3.linear.RRQRDecomposition;
import org.apache.commons.math3.linear.RealMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CommonsMathLinearSystemSolver
implements LinearSystemSolver {
    private static final Logger log = LoggerFactory.getLogger(CommonsMathLinearSystemSolver.class);

    @Override
    public Solver getSolver(RealMatrix M) {
        if (M == null) {
            return null;
        }
        RRQRDecomposition decomposition = new RRQRDecomposition(M, SINGULARITY_THRESHOLD);
        DecompositionSolver solver = decomposition.getSolver();
        if (solver.isNonSingular()) {
            return new CommonsMathSolver(solver);
        }
        int apparentRank = decomposition.getRank(0.01);
        log.warn("{} x {} matrix is near-singular (threshold {}). Add more data or decrease the value of model.features, to <= about {}", new Object[]{M.getRowDimension(), M.getColumnDimension(), SINGULARITY_THRESHOLD, apparentRank});
        throw new SingularMatrixSolverException("Apparent rank: " + apparentRank);
    }

    @Override
    public boolean isNonSingular(RealMatrix M) {
        RRQRDecomposition decomposition = new RRQRDecomposition(M, SINGULARITY_THRESHOLD);
        DecompositionSolver solver = decomposition.getSolver();
        return solver.isNonSingular();
    }
}

