/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReloadingReference<V> {
    private static final Logger log = LoggerFactory.getLogger(ReloadingReference.class);
    public static final long NO_RELOAD = -1L;
    private V value;
    private final Callable<V> retriever;
    private long lastRetrieval;
    private final long originalDurationMS;
    private long currentDurationMS;
    private final Lock lock;

    public ReloadingReference(Callable<V> retriever) {
        this(retriever, -1L, null);
    }

    public ReloadingReference(Callable<V> retriever, long duration, TimeUnit timeUnit) {
        Preconditions.checkNotNull(retriever);
        this.retriever = retriever;
        if (duration == -1L) {
            this.originalDurationMS = -1L;
        } else {
            Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (String)"Duration must be positive: %s", (Object[])new Object[]{duration});
            Preconditions.checkNotNull((Object)((Object)timeUnit));
            this.originalDurationMS = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
        }
        this.currentDurationMS = this.originalDurationMS;
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long timeout, TimeUnit timeUnit) {
        block5: {
            try {
                if (!this.lock.tryLock(timeout, timeUnit)) break block5;
                try {
                    this.doGet();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        V theValue = this.value;
        return theValue == null ? this.get() : theValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get() {
        this.lock.lock();
        try {
            this.doGet();
        }
        finally {
            this.lock.unlock();
        }
        return this.value;
    }

    private void doGet() {
        long now;
        boolean reloading = this.originalDurationMS > 0L;
        long l = now = reloading ? System.currentTimeMillis() : 0L;
        if (this.value == null || reloading && now > this.lastRetrieval + this.currentDurationMS) {
            try {
                this.value = this.retriever.call();
                Preconditions.checkState((this.value != null ? 1 : 0) != 0);
            }
            catch (Exception e) {
                if (this.currentDurationMS >= this.originalDurationMS * 16L || this.value == null) {
                    throw new IllegalStateException(e);
                }
                log.warn("Retrieval failed; using previous cached value", (Throwable)e);
                this.currentDurationMS *= 2L;
            }
            this.lastRetrieval = System.currentTimeMillis();
            this.currentDurationMS = this.originalDurationMS;
        }
    }

    public V maybeGet() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.value = null;
        }
        finally {
            this.lock.unlock();
        }
    }
}

