/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.stats;

import java.util.concurrent.TimeUnit;
import net.myrrix.common.MyrrixTest;
import net.myrrix.common.stats.RunningStatisticsPerTime;
import org.junit.Test;

public final class RunningStatisticsPerTimeTest
extends MyrrixTest {
    @Test
    public void testInit() {
        RunningStatisticsPerTime perTime = new RunningStatisticsPerTime(TimeUnit.MINUTES);
        RunningStatisticsPerTimeTest.assertTrue((boolean)Double.isNaN(perTime.getMin()));
        RunningStatisticsPerTimeTest.assertTrue((boolean)Double.isNaN(perTime.getMax()));
        RunningStatisticsPerTimeTest.assertTrue((boolean)Double.isNaN(perTime.getAverage()));
        RunningStatisticsPerTimeTest.assertEquals((long)0L, (long)perTime.getCount());
    }

    @Test
    public void testOneBucket() {
        RunningStatisticsPerTime perTime = new RunningStatisticsPerTime(TimeUnit.MINUTES);
        perTime.addDatum(1.2);
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getMin());
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getMax());
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getAverage());
        RunningStatisticsPerTimeTest.assertEquals((long)1L, (long)perTime.getCount());
    }

    @Test
    public void testRoll() throws Exception {
        RunningStatisticsPerTime perTime = new RunningStatisticsPerTime(TimeUnit.MINUTES);
        perTime.addDatum(1.2);
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getMin());
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getMax());
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getAverage());
        RunningStatisticsPerTimeTest.assertEquals((long)1L, (long)perTime.getCount());
        Thread.sleep(2000L);
        perTime.addDatum(2.0);
        RunningStatisticsPerTimeTest.assertEquals(1.2, perTime.getMin());
        RunningStatisticsPerTimeTest.assertEquals(2.0, perTime.getMax());
        RunningStatisticsPerTimeTest.assertEquals(1.6, perTime.getAverage());
        RunningStatisticsPerTimeTest.assertEquals((long)2L, (long)perTime.getCount());
        Thread.sleep(58000L);
        perTime.refresh();
        RunningStatisticsPerTimeTest.assertEquals(2.0, perTime.getMin());
        RunningStatisticsPerTimeTest.assertEquals(2.0, perTime.getMax());
        RunningStatisticsPerTimeTest.assertEquals(2.0, perTime.getAverage());
        RunningStatisticsPerTimeTest.assertEquals((long)1L, (long)perTime.getCount());
        Thread.sleep(2000L);
        perTime.refresh();
        RunningStatisticsPerTimeTest.assertTrue((boolean)Double.isNaN(perTime.getMin()));
        RunningStatisticsPerTimeTest.assertTrue((boolean)Double.isNaN(perTime.getMax()));
        RunningStatisticsPerTimeTest.assertTrue((boolean)Double.isNaN(perTime.getAverage()));
        RunningStatisticsPerTimeTest.assertEquals((long)0L, (long)perTime.getCount());
    }
}

