/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import com.google.common.base.Stopwatch;
import java.util.concurrent.TimeUnit;
import net.myrrix.common.MyrrixTest;
import net.myrrix.common.math.MatrixUtils;
import net.myrrix.common.random.RandomManager;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.RealMatrix;
import org.apache.commons.math3.random.RandomGenerator;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SolverLoadTest
extends MyrrixTest {
    private static final Logger log = LoggerFactory.getLogger(SolverLoadTest.class);

    @Test
    public void testLoad() {
        RealMatrix symmetric = SolverLoadTest.randomSymmetricMatrix(500);
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        int iterations = 100;
        for (int i = 0; i < iterations; ++i) {
            MatrixUtils.getSolver((RealMatrix)symmetric);
        }
        stopwatch.stop();
        long elapsedMS = stopwatch.elapsed(TimeUnit.MILLISECONDS);
        log.info("{}ms elapsed", (Object)elapsedMS);
        SolverLoadTest.assertTrue((elapsedMS < (long)(300 * iterations) ? 1 : 0) != 0);
    }

    private static RealMatrix randomSymmetricMatrix(int dimension) {
        RandomGenerator random = RandomManager.getRandom();
        Array2DRowRealMatrix symmetric = new Array2DRowRealMatrix(dimension, dimension);
        for (int j = 0; j < dimension; ++j) {
            symmetric.setEntry(j, j, random.nextDouble());
            for (int k = j + 1; k < dimension; ++k) {
                double d = random.nextDouble();
                symmetric.setEntry(j, k, d);
                symmetric.setEntry(k, j, d);
            }
        }
        return symmetric;
    }
}

