/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.math;

import net.myrrix.common.MyrrixTest;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.collection.FastByIDMap;
import net.myrrix.common.math.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.junit.Test;

public final class MatrixUtilsTest
extends MyrrixTest {
    @Test
    public void testAddTo() {
        FastByIDMap byRow = new FastByIDMap();
        MatrixUtilsTest.assertNull((Object)byRow.get(0L));
        MatrixUtilsTest.assertNull((Object)byRow.get(1L));
        MatrixUtilsTest.assertNull((Object)byRow.get(4L));
        FastByIDMap byCol = new FastByIDMap();
        MatrixUtils.addTo((long)0L, (long)0L, (float)-1.0f, (FastByIDMap)byRow, (FastByIDMap)byCol);
        MatrixUtils.addTo((long)4L, (long)1L, (float)2.0f, (FastByIDMap)byRow, (FastByIDMap)byCol);
        MatrixUtilsTest.assertEquals(-1.0f, ((FastByIDFloatMap)byRow.get(0L)).get(0L));
        MatrixUtilsTest.assertEquals(-1.0f, ((FastByIDFloatMap)byCol.get(0L)).get(0L));
        MatrixUtilsTest.assertNull((Object)byRow.get(1L));
        MatrixUtilsTest.assertEquals(2.0f, ((FastByIDFloatMap)byRow.get(4L)).get(1L));
        MatrixUtilsTest.assertEquals(2.0f, ((FastByIDFloatMap)byCol.get(1L)).get(4L));
        MatrixUtilsTest.assertNaN(((FastByIDFloatMap)byRow.get(4L)).get(0L));
    }

    @Test
    public void testRemove() {
        FastByIDMap byRow = new FastByIDMap();
        FastByIDMap byCol = new FastByIDMap();
        MatrixUtils.addTo((long)0L, (long)0L, (float)-1.0f, (FastByIDMap)byRow, (FastByIDMap)byCol);
        MatrixUtils.addTo((long)4L, (long)1L, (float)2.0f, (FastByIDMap)byRow, (FastByIDMap)byCol);
        MatrixUtils.remove((long)0L, (long)0L, (FastByIDMap)byRow, (FastByIDMap)byCol);
        MatrixUtilsTest.assertNull((Object)byRow.get(0L));
        MatrixUtilsTest.assertEquals(2.0f, ((FastByIDFloatMap)byRow.get(4L)).get(1L));
        MatrixUtilsTest.assertEquals(2.0f, ((FastByIDFloatMap)byCol.get(1L)).get(4L));
    }

    @Test
    public void testTransposeTimesSelf() {
        FastByIDMap M = new FastByIDMap();
        M.put(1L, (Object)new float[]{4.0f, -1.0f, -5.0f});
        M.put(2L, (Object)new float[]{2.0f, 0.0f, 3.0f});
        RealMatrix MTM = MatrixUtils.transposeTimesSelf((FastByIDMap)M);
        MatrixUtilsTest.assertArrayEquals(new double[]{20.0, -4.0, -14.0}, MTM.getRow(0));
        MatrixUtilsTest.assertArrayEquals(new double[]{-4.0, 1.0, 5.0}, MTM.getRow(1));
        MatrixUtilsTest.assertArrayEquals(new double[]{-14.0, 5.0, 34.0}, MTM.getRow(2));
    }
}

