/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.io;

import com.google.common.io.Files;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import net.myrrix.common.MyrrixTest;
import net.myrrix.common.io.IOUtils;
import org.junit.Test;

public final class IOUtilsTest
extends MyrrixTest {
    private static final byte[] SOME_BYTES = new byte[]{1, 2, 3};

    @Test
    public void testCopyStream() throws IOException {
        File tempDir = this.getTestTempDir();
        File subFile1 = new File(tempDir, "subFile1");
        Files.write((byte[])SOME_BYTES, (File)subFile1);
        File subFile2 = new File(tempDir, "subFile2");
        IOUtils.copyURLToFile((URL)subFile1.toURI().toURL(), (File)subFile2);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Files.copy((File)subFile2, (OutputStream)baos);
        IOUtilsTest.assertArrayEquals((byte[])SOME_BYTES, (byte[])baos.toByteArray());
    }

    @Test
    public void testDeleteRecursively() throws IOException {
        File tempDir = this.getTestTempDir();
        IOUtilsTest.assertTrue((boolean)tempDir.exists());
        File subFile1 = new File(tempDir, "subFile1");
        Files.write((byte[])SOME_BYTES, (File)subFile1);
        IOUtilsTest.assertTrue((boolean)subFile1.exists());
        File subDir1 = new File(tempDir, "subDir1");
        subDir1.mkdirs();
        IOUtilsTest.assertTrue((boolean)subDir1.exists());
        File subFile2 = new File(subDir1, "subFile2");
        Files.write((byte[])SOME_BYTES, (File)subFile2);
        IOUtilsTest.assertTrue((boolean)subFile2.exists());
        File subDir2 = new File(subDir1, "subDir2");
        subDir2.mkdirs();
        IOUtilsTest.assertTrue((boolean)subDir2.exists());
        IOUtils.deleteRecursively((File)tempDir);
        IOUtilsTest.assertFalse((boolean)tempDir.exists());
        IOUtilsTest.assertFalse((boolean)subFile1.exists());
        IOUtilsTest.assertFalse((boolean)subDir1.exists());
        IOUtilsTest.assertFalse((boolean)subFile2.exists());
        IOUtilsTest.assertFalse((boolean)subDir2.exists());
    }
}

