/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.collection;

import java.util.HashSet;
import net.myrrix.common.MyrrixTest;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.random.RandomManager;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.junit.Test;

public final class FastIDSetTest
extends MyrrixTest {
    @Test
    public void testContainsAndAdd() {
        FastIDSet set = new FastIDSet();
        FastIDSetTest.assertFalse((boolean)set.contains(1L));
        set.add(1L);
        FastIDSetTest.assertTrue((boolean)set.contains(1L));
    }

    @Test
    public void testRemove() {
        FastIDSet set = new FastIDSet();
        set.add(1L);
        set.remove(1L);
        FastIDSetTest.assertEquals((long)0L, (long)set.size());
        FastIDSetTest.assertTrue((boolean)set.isEmpty());
        FastIDSetTest.assertFalse((boolean)set.contains(1L));
    }

    @Test
    public void testClear() {
        FastIDSet set = new FastIDSet();
        set.add(1L);
        set.clear();
        FastIDSetTest.assertEquals((long)0L, (long)set.size());
        FastIDSetTest.assertTrue((boolean)set.isEmpty());
        FastIDSetTest.assertFalse((boolean)set.contains(1L));
    }

    @Test
    public void testSizeEmpty() {
        FastIDSet set = new FastIDSet();
        FastIDSetTest.assertEquals((long)0L, (long)set.size());
        FastIDSetTest.assertTrue((boolean)set.isEmpty());
        set.add(1L);
        FastIDSetTest.assertEquals((long)1L, (long)set.size());
        FastIDSetTest.assertFalse((boolean)set.isEmpty());
        set.remove(1L);
        FastIDSetTest.assertEquals((long)0L, (long)set.size());
        FastIDSetTest.assertTrue((boolean)set.isEmpty());
    }

    @Test
    public void testContains() {
        FastIDSet set = FastIDSetTest.buildTestFastSet();
        FastIDSetTest.assertTrue((boolean)set.contains(1L));
        FastIDSetTest.assertTrue((boolean)set.contains(2L));
        FastIDSetTest.assertTrue((boolean)set.contains(3L));
        FastIDSetTest.assertFalse((boolean)set.contains(4L));
    }

    @Test
    public void testReservedValues() {
        FastIDSet set = new FastIDSet();
        try {
            set.add(Long.MIN_VALUE);
            FastIDSetTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        FastIDSetTest.assertFalse((boolean)set.contains(Long.MIN_VALUE));
        try {
            set.add(Long.MAX_VALUE);
            FastIDSetTest.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        FastIDSetTest.assertFalse((boolean)set.contains(Long.MAX_VALUE));
    }

    @Test
    public void testRehash() {
        FastIDSet set = FastIDSetTest.buildTestFastSet();
        set.remove(1L);
        set.rehash();
        FastIDSetTest.assertFalse((boolean)set.contains(1L));
    }

    @Test
    public void testGrow() {
        FastIDSet set = new FastIDSet(1);
        set.add(1L);
        set.add(2L);
        FastIDSetTest.assertTrue((boolean)set.contains(1L));
        FastIDSetTest.assertTrue((boolean)set.contains(2L));
    }

    @Test
    public void testIterator() {
        FastIDSet set = FastIDSetTest.buildTestFastSet();
        HashSet<Long> expected = new HashSet<Long>(3);
        expected.add(1L);
        expected.add(2L);
        expected.add(3L);
        LongPrimitiveIterator it = set.iterator();
        while (it.hasNext()) {
            expected.remove(it.nextLong());
        }
        FastIDSetTest.assertTrue((boolean)expected.isEmpty());
    }

    @Test
    public void testVersusHashSet() {
        FastIDSet actual = new FastIDSet(1);
        HashSet<Integer> expected = new HashSet<Integer>(1000000);
        RandomGenerator r = RandomManager.getRandom();
        for (int i = 0; i < 1000000; ++i) {
            double d = r.nextDouble();
            Integer key = r.nextInt(100);
            if (d < 0.4) {
                FastIDSetTest.assertEquals((Object)expected.contains(key), (Object)actual.contains((long)key.intValue()));
                continue;
            }
            if (d < 0.7) {
                FastIDSetTest.assertEquals((Object)expected.add(key), (Object)actual.add((long)key.intValue()));
            } else {
                FastIDSetTest.assertEquals((Object)expected.remove(key), (Object)actual.remove((long)key.intValue()));
            }
            FastIDSetTest.assertEquals((long)expected.size(), (long)actual.size());
            FastIDSetTest.assertEquals((Object)expected.isEmpty(), (Object)actual.isEmpty());
        }
    }

    private static FastIDSet buildTestFastSet() {
        FastIDSet set = new FastIDSet();
        set.add(1L);
        set.add(2L);
        set.add(3L);
        return set;
    }
}

