/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.collection;

import com.google.common.collect.Maps;
import java.util.HashMap;
import net.myrrix.common.MyrrixTest;
import net.myrrix.common.collection.FastByIDFloatMap;
import net.myrrix.common.random.RandomManager;
import org.apache.commons.math3.random.RandomGenerator;
import org.junit.Test;

public final class FastByIDFloatMapTest
extends MyrrixTest {
    @Test
    public void testPutAndGet() {
        FastByIDFloatMap map = new FastByIDFloatMap();
        FastByIDFloatMapTest.assertNaN(map.get(500000L));
        map.put(500000L, 2.0f);
        FastByIDFloatMapTest.assertEquals(2.0f, map.get(500000L));
    }

    @Test
    public void testRemove() {
        FastByIDFloatMap map = new FastByIDFloatMap();
        map.put(500000L, 2.0f);
        map.remove(500000L);
        FastByIDFloatMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDFloatMapTest.assertTrue((boolean)map.isEmpty());
        FastByIDFloatMapTest.assertNaN(map.get(500000L));
    }

    @Test
    public void testClear() {
        FastByIDFloatMap map = new FastByIDFloatMap();
        map.put(500000L, 2.0f);
        map.clear();
        FastByIDFloatMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDFloatMapTest.assertTrue((boolean)map.isEmpty());
        FastByIDFloatMapTest.assertNaN(map.get(500000L));
    }

    @Test
    public void testSizeEmpty() {
        FastByIDFloatMap map = new FastByIDFloatMap();
        FastByIDFloatMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDFloatMapTest.assertTrue((boolean)map.isEmpty());
        map.put(500000L, 2.0f);
        FastByIDFloatMapTest.assertEquals((long)1L, (long)map.size());
        FastByIDFloatMapTest.assertFalse((boolean)map.isEmpty());
        map.remove(500000L);
        FastByIDFloatMapTest.assertEquals((long)0L, (long)map.size());
        FastByIDFloatMapTest.assertTrue((boolean)map.isEmpty());
    }

    @Test
    public void testContains() {
        FastByIDFloatMap map = FastByIDFloatMapTest.buildTestFastMap();
        FastByIDFloatMapTest.assertTrue((boolean)map.containsKey(500000L));
        FastByIDFloatMapTest.assertTrue((boolean)map.containsKey(47L));
        FastByIDFloatMapTest.assertTrue((boolean)map.containsKey(2L));
        FastByIDFloatMapTest.assertFalse((boolean)map.containsKey(999L));
    }

    @Test
    public void testRehash() {
        FastByIDFloatMap map = FastByIDFloatMapTest.buildTestFastMap();
        map.remove(500000L);
        map.rehash();
        FastByIDFloatMapTest.assertNaN(map.get(500000L));
        FastByIDFloatMapTest.assertEquals(3.0f, map.get(47L));
    }

    @Test
    public void testVersusHashMap() {
        FastByIDFloatMap actual = new FastByIDFloatMap();
        HashMap expected = Maps.newHashMapWithExpectedSize((int)1000000);
        RandomGenerator r = RandomManager.getRandom();
        for (int i = 0; i < 1000000; ++i) {
            double d = r.nextDouble();
            Long key = r.nextInt(100);
            if (d < 0.4) {
                Float expectedValue = (Float)expected.get(key);
                float actualValue = actual.get(key.longValue());
                if (expectedValue == null) {
                    FastByIDFloatMapTest.assertNaN(actualValue);
                    continue;
                }
                FastByIDFloatMapTest.assertEquals(expectedValue.floatValue(), actualValue);
                continue;
            }
            if (d < 0.7) {
                expected.put(key, Float.valueOf(3.0f));
                actual.put(key.longValue(), 3.0f);
            } else {
                expected.remove(key);
                actual.remove(key.longValue());
            }
            FastByIDFloatMapTest.assertEquals((long)expected.size(), (long)actual.size());
            FastByIDFloatMapTest.assertEquals((Object)expected.isEmpty(), (Object)actual.isEmpty());
        }
    }

    @Test
    public void testMaxSize() {
        FastByIDFloatMap map = new FastByIDFloatMap();
        map.put(4L, 3.0f);
        FastByIDFloatMapTest.assertEquals((long)1L, (long)map.size());
        map.put(47L, 3.0f);
        FastByIDFloatMapTest.assertEquals((long)2L, (long)map.size());
        FastByIDFloatMapTest.assertNaN(map.get(500000L));
        map.put(47L, 5.0f);
        FastByIDFloatMapTest.assertEquals((long)2L, (long)map.size());
        FastByIDFloatMapTest.assertEquals(5.0f, map.get(47L));
    }

    private static FastByIDFloatMap buildTestFastMap() {
        FastByIDFloatMap map = new FastByIDFloatMap();
        map.put(500000L, 2.0f);
        map.put(47L, 3.0f);
        map.put(2L, 5.0f);
        return map;
    }
}

