/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.collection;

import net.myrrix.common.MyrrixTest;
import net.myrrix.common.collection.BitSet;
import net.myrrix.common.random.RandomManager;
import org.apache.commons.math3.random.RandomGenerator;
import org.junit.Test;

public final class BitSetTest
extends MyrrixTest {
    private static final int NUM_BITS = 100;

    @Test
    public void testGetSet() {
        BitSet bitSet = new BitSet(100);
        for (int i = 0; i < 100; ++i) {
            BitSetTest.assertFalse((boolean)bitSet.get(i));
        }
        bitSet.set(0);
        bitSet.set(99);
        BitSetTest.assertTrue((boolean)bitSet.get(0));
        BitSetTest.assertTrue((boolean)bitSet.get(99));
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testBounds1() {
        BitSet bitSet = new BitSet(100);
        bitSet.set(1000);
    }

    @Test(expected=ArrayIndexOutOfBoundsException.class)
    public void testBounds2() {
        BitSet bitSet = new BitSet(100);
        bitSet.set(-1);
    }

    @Test
    public void testClear() {
        int i;
        BitSet bitSet = new BitSet(100);
        for (i = 0; i < 100; ++i) {
            bitSet.set(i);
        }
        for (i = 0; i < 100; ++i) {
            BitSetTest.assertTrue((boolean)bitSet.get(i));
        }
        bitSet.clear();
        for (i = 0; i < 100; ++i) {
            BitSetTest.assertFalse((boolean)bitSet.get(i));
        }
    }

    @Test
    public void testSize() {
        BitSet bitSet = new BitSet(100);
        BitSetTest.assertEquals((long)128L, (long)bitSet.size());
    }

    @Test
    public void testCardinality() {
        BitSet bitSet = new BitSet(100);
        BitSetTest.assertEquals((long)0L, (long)bitSet.cardinality());
        bitSet.set(0);
        BitSetTest.assertEquals((long)1L, (long)bitSet.cardinality());
        bitSet.set(0);
        BitSetTest.assertEquals((long)1L, (long)bitSet.cardinality());
        bitSet.set(1);
        BitSetTest.assertEquals((long)2L, (long)bitSet.cardinality());
        bitSet.set(63);
        BitSetTest.assertEquals((long)3L, (long)bitSet.cardinality());
        bitSet.set(64);
        BitSetTest.assertEquals((long)4L, (long)bitSet.cardinality());
        bitSet.set(99);
        BitSetTest.assertEquals((long)5L, (long)bitSet.cardinality());
        bitSet.clear(0);
        BitSetTest.assertEquals((long)4L, (long)bitSet.cardinality());
    }

    @Test
    public void testNextSetBit() {
        BitSet bitSet = new BitSet(100);
        BitSetTest.assertEquals((long)-1L, (long)bitSet.nextSetBit(0));
        bitSet.set(3);
        BitSetTest.assertEquals((long)3L, (long)bitSet.nextSetBit(0));
        BitSetTest.assertEquals((long)3L, (long)bitSet.nextSetBit(2));
        BitSetTest.assertEquals((long)3L, (long)bitSet.nextSetBit(3));
        BitSetTest.assertEquals((long)-1L, (long)bitSet.nextSetBit(4));
        bitSet.set(5);
        bitSet.set(7);
        BitSetTest.assertEquals((long)5L, (long)bitSet.nextSetBit(4));
        BitSetTest.assertEquals((long)5L, (long)bitSet.nextSetBit(5));
        BitSetTest.assertEquals((long)7L, (long)bitSet.nextSetBit(6));
        bitSet.set(64);
        BitSetTest.assertEquals((long)64L, (long)bitSet.nextSetBit(8));
        BitSetTest.assertEquals((long)64L, (long)bitSet.nextSetBit(63));
        BitSetTest.assertEquals((long)64L, (long)bitSet.nextSetBit(64));
        BitSetTest.assertEquals((long)-1L, (long)bitSet.nextSetBit(65));
        BitSetTest.assertEquals((long)-1L, (long)bitSet.nextSetBit(99));
    }

    @Test
    public void testNextBitSetRandom() {
        RandomGenerator random = RandomManager.getRandom();
        for (int i = 0; i < 100; ++i) {
            int j;
            BitSet bitSet = new BitSet(100);
            for (int j2 = 0; j2 < 20 + random.nextInt(50); ++j2) {
                bitSet.set(random.nextInt(100));
            }
            int from = random.nextInt(100);
            int nextSet = bitSet.nextSetBit(from);
            if (nextSet == -1) {
                for (j = from; j < 100; ++j) {
                    BitSetTest.assertFalse((boolean)bitSet.get(j));
                }
                continue;
            }
            for (j = from; j < nextSet; ++j) {
                BitSetTest.assertFalse((boolean)bitSet.get(j));
            }
            BitSetTest.assertTrue((boolean)bitSet.get(nextSet));
        }
    }

    @Test
    public void testClone() {
        BitSet bitSet = new BitSet(100);
        bitSet.set(99);
        bitSet = bitSet.clone();
        BitSetTest.assertTrue((boolean)bitSet.get(99));
    }
}

