/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.myrrix.common.MyrrixTest;
import net.myrrix.common.TopN;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.junit.Test;

public final class TopNTest
extends MyrrixTest {
    @Test
    public void testEmpty() {
        List empty = Collections.emptyList();
        List top2 = TopN.selectTopN(empty.iterator(), (int)2);
        TopNTest.assertNotNull((Object)top2);
        TopNTest.assertEquals((long)0L, (long)top2.size());
    }

    @Test
    public void testTopExactly() {
        List<RecommendedItem> candidates = TopNTest.makeNCandidates(3);
        List top3 = TopN.selectTopN(candidates.iterator(), (int)3);
        TopNTest.assertNotNull((Object)top3);
        TopNTest.assertEquals((long)3L, (long)top3.size());
        TopNTest.assertEquals((long)3L, (long)((RecommendedItem)top3.get(0)).getItemID());
        TopNTest.assertEquals(3.0f, ((RecommendedItem)top3.get(0)).getValue());
        TopNTest.assertEquals((long)1L, (long)((RecommendedItem)top3.get(2)).getItemID());
        TopNTest.assertEquals(1.0f, ((RecommendedItem)top3.get(2)).getValue());
    }

    @Test
    public void testTopPlusOne() {
        List<RecommendedItem> candidates = TopNTest.makeNCandidates(4);
        List top3 = TopN.selectTopN(candidates.iterator(), (int)3);
        TopNTest.assertNotNull((Object)top3);
        TopNTest.assertEquals((long)3L, (long)top3.size());
        TopNTest.assertEquals((long)4L, (long)((RecommendedItem)top3.get(0)).getItemID());
        TopNTest.assertEquals(4.0f, ((RecommendedItem)top3.get(0)).getValue());
        TopNTest.assertEquals((long)2L, (long)((RecommendedItem)top3.get(2)).getItemID());
        TopNTest.assertEquals(2.0f, ((RecommendedItem)top3.get(2)).getValue());
    }

    @Test
    public void testTopOfMany() {
        List<RecommendedItem> candidates = TopNTest.makeNCandidates(20);
        List top3 = TopN.selectTopN(candidates.iterator(), (int)3);
        TopNTest.assertNotNull((Object)top3);
        TopNTest.assertEquals((long)3L, (long)top3.size());
        TopNTest.assertEquals((long)20L, (long)((RecommendedItem)top3.get(0)).getItemID());
        TopNTest.assertEquals(20.0f, ((RecommendedItem)top3.get(0)).getValue());
        TopNTest.assertEquals((long)18L, (long)((RecommendedItem)top3.get(2)).getItemID());
        TopNTest.assertEquals(18.0f, ((RecommendedItem)top3.get(2)).getValue());
    }

    private static List<RecommendedItem> makeNCandidates(int n) {
        ArrayList candidates = Lists.newArrayListWithCapacity((int)n);
        for (int i = 1; i <= n; ++i) {
            candidates.add(new GenericRecommendedItem((long)i, (float)i));
        }
        return candidates;
    }
}

