/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.io.Files;
import java.io.File;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.log.MemoryHandler;
import net.myrrix.common.random.RandomManager;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public abstract class MyrrixTest
extends Assert {
    private static final float FLOAT_EPSILON = 1.0E-6f;
    private static final double DOUBLE_EPSILON = 1.0E-12;
    private File testTempDir;

    public static void assertEquals(float expected, float actual) {
        Assert.assertEquals((float)expected, (float)actual, (float)1.0E-6f);
    }

    public static void assertEquals(String message, float expected, float actual) {
        Assert.assertEquals((String)message, (float)expected, (float)actual, (float)1.0E-6f);
    }

    public static void assertArrayEquals(float[] expecteds, float[] actuals) {
        Assert.assertArrayEquals((float[])expecteds, (float[])actuals, (float)1.0E-6f);
    }

    public static void assertEquals(double expected, double actual) {
        Assert.assertEquals((double)expected, (double)actual, (double)1.0E-12);
    }

    public static void assertEquals(String message, double expected, double actual) {
        Assert.assertEquals((String)message, (double)expected, (double)actual, (double)1.0E-12);
    }

    public static void assertArrayEquals(double[] expecteds, double[] actuals) {
        Assert.assertArrayEquals((double[])expecteds, (double[])actuals, (double)1.0E-12);
    }

    public static void assertArrayEquals(float[] expecteds, double[] actuals) {
        MyrrixTest.assertArrayEquals(expecteds, MyrrixTest.doubleToFloatArray(actuals));
    }

    protected static float[] doubleToFloatArray(double[] d) {
        float[] f = new float[d.length];
        for (int i = 0; i < d.length; ++i) {
            f[i] = (float)d[i];
        }
        return f;
    }

    @BeforeClass
    public static void setUpClass() {
        MemoryHandler.setSensibleLogFormat();
    }

    @Before
    public void setUp() throws Exception {
        this.testTempDir = null;
        RandomManager.useTestSeed();
    }

    @After
    public void tearDown() throws Exception {
        IOUtils.deleteRecursively((File)this.testTempDir);
    }

    protected static void assertNaN(double d) {
        MyrrixTest.assertTrue((String)("Expected NaN but got " + d), (boolean)Double.isNaN(d));
    }

    protected static void assertNaN(float f) {
        MyrrixTest.assertTrue((String)("Expected NaN but got " + f), (boolean)Float.isNaN(f));
    }

    protected final synchronized File getTestTempDir() {
        if (this.testTempDir == null) {
            this.testTempDir = Files.createTempDir();
            this.testTempDir.deleteOnExit();
        }
        return this.testTempDir;
    }
}

