/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.collection.CountingIterator;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.parallel.Paralleler;
import net.myrrix.common.parallel.Processor;
import net.myrrix.common.random.RandomManager;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LoadRunner
implements Callable<Void> {
    private static final Logger log = LoggerFactory.getLogger(LoadRunner.class);
    private final MyrrixRecommender client;
    private final long[] uniqueUserIDs;
    private final long[] uniqueItemIDs;
    private final int steps;

    public LoadRunner(MyrrixRecommender client, File dataDirectory, int steps) throws IOException {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)dataDirectory);
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0);
        log.info("Reading IDs...");
        FastIDSet userIDsSet = new FastIDSet();
        FastIDSet itemIDsSet = new FastIDSet();
        Splitter comma = Splitter.on((char)',');
        for (File f : dataDirectory.listFiles((FilenameFilter)new PatternFilenameFilter(".+\\.csv(\\.(zip|gz))?"))) {
            for (CharSequence line : new FileLineIterable(f)) {
                Iterator it = comma.split(line).iterator();
                userIDsSet.add(Long.parseLong((String)it.next()));
                itemIDsSet.add(Long.parseLong((String)it.next()));
            }
        }
        this.client = client;
        this.uniqueUserIDs = userIDsSet.toArray();
        this.uniqueItemIDs = itemIDsSet.toArray();
        this.steps = steps;
    }

    public LoadRunner(MyrrixRecommender client, long[] uniqueUserIDs, long[] uniqueItemIDs, int steps) {
        Preconditions.checkNotNull((Object)client);
        Preconditions.checkNotNull((Object)uniqueItemIDs);
        Preconditions.checkNotNull((Object)uniqueItemIDs);
        Preconditions.checkArgument((steps > 0 ? 1 : 0) != 0, (String)"steps must be positive: {}", (Object[])new Object[]{steps});
        this.client = client;
        this.uniqueUserIDs = uniqueUserIDs;
        this.uniqueItemIDs = uniqueItemIDs;
        this.steps = steps;
    }

    public int getSteps() {
        return this.steps;
    }

    @Override
    public Void call() throws Exception {
        this.runLoad();
        return null;
    }

    public void runLoad() throws ExecutionException, InterruptedException {
        FullRunningAverageAndStdDev recommendedBecause = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev setPreference = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev removePreference = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev setTag = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev ingest = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev refresh = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev estimatePreference = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev mostSimilarItems = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev similarityToItem = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev mostPopularItems = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev recommendToMany = new FullRunningAverageAndStdDev();
        FullRunningAverageAndStdDev recommend = new FullRunningAverageAndStdDev();
        Processor<Integer> processor = new Processor<Integer>((RunningAverage)recommendedBecause, (RunningAverage)setPreference, (RunningAverage)setTag, (RunningAverage)removePreference, (RunningAverage)ingest, (RunningAverage)refresh, (RunningAverage)similarityToItem, (RunningAverage)mostPopularItems, (RunningAverage)estimatePreference, (RunningAverage)mostSimilarItems, (RunningAverage)recommendToMany, (RunningAverage)recommend){
            private final RandomGenerator random = RandomManager.getRandom();
            final /* synthetic */ RunningAverage val$recommendedBecause;
            final /* synthetic */ RunningAverage val$setPreference;
            final /* synthetic */ RunningAverage val$setTag;
            final /* synthetic */ RunningAverage val$removePreference;
            final /* synthetic */ RunningAverage val$ingest;
            final /* synthetic */ RunningAverage val$refresh;
            final /* synthetic */ RunningAverage val$similarityToItem;
            final /* synthetic */ RunningAverage val$mostPopularItems;
            final /* synthetic */ RunningAverage val$estimatePreference;
            final /* synthetic */ RunningAverage val$mostSimilarItems;
            final /* synthetic */ RunningAverage val$recommendToMany;
            final /* synthetic */ RunningAverage val$recommend;
            {
                this.val$recommendedBecause = runningAverage;
                this.val$setPreference = runningAverage2;
                this.val$setTag = runningAverage3;
                this.val$removePreference = runningAverage4;
                this.val$ingest = runningAverage5;
                this.val$refresh = runningAverage6;
                this.val$similarityToItem = runningAverage7;
                this.val$mostPopularItems = runningAverage8;
                this.val$estimatePreference = runningAverage9;
                this.val$mostSimilarItems = runningAverage10;
                this.val$recommendToMany = runningAverage11;
                this.val$recommend = runningAverage12;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void process(Integer step, long count) {
                float value;
                long itemID2;
                long itemID;
                long userID;
                double r;
                RandomGenerator randomGenerator = this.random;
                synchronized (randomGenerator) {
                    r = this.random.nextDouble();
                    userID = LoadRunner.this.uniqueUserIDs[this.random.nextInt(LoadRunner.this.uniqueUserIDs.length)];
                    itemID = LoadRunner.this.uniqueItemIDs[this.random.nextInt(LoadRunner.this.uniqueItemIDs.length)];
                    itemID2 = LoadRunner.this.uniqueItemIDs[this.random.nextInt(LoadRunner.this.uniqueItemIDs.length)];
                    value = this.random.nextInt(10);
                }
                long stepStart = System.currentTimeMillis();
                try {
                    if (r < 0.05) {
                        LoadRunner.this.client.recommendedBecause(userID, itemID, 10);
                        this.val$recommendedBecause.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.07) {
                        LoadRunner.this.client.setPreference(userID, itemID);
                        this.val$setPreference.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.08) {
                        LoadRunner.this.client.setPreference(userID, itemID, value);
                        this.val$setPreference.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.09) {
                        LoadRunner.this.client.setUserTag(userID, Long.toString(itemID));
                        this.val$setTag.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.1) {
                        LoadRunner.this.client.setItemTag(Long.toString(userID), itemID);
                        this.val$setTag.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.11) {
                        LoadRunner.this.client.removePreference(userID, itemID);
                        this.val$removePreference.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.12) {
                        StringReader reader = new StringReader(userID + "," + itemID + ',' + value + '\n');
                        LoadRunner.this.client.ingest((Reader)reader);
                        this.val$ingest.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.13) {
                        LoadRunner.this.client.refresh();
                        this.val$refresh.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.14) {
                        LoadRunner.this.client.similarityToItem(itemID, new long[]{itemID2});
                        this.val$similarityToItem.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.15) {
                        LoadRunner.this.client.mostPopularItems(10);
                        this.val$mostPopularItems.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.19) {
                        LoadRunner.this.client.estimatePreference(userID, itemID);
                        this.val$estimatePreference.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.2) {
                        LoadRunner.this.client.estimateForAnonymous(itemID, new long[]{itemID2});
                        this.val$estimatePreference.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.25) {
                        LoadRunner.this.client.mostSimilarItems(new long[]{itemID}, 10);
                        this.val$mostSimilarItems.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else if (r < 0.3) {
                        LoadRunner.this.client.recommendToMany(new long[]{userID, userID}, 10, true, null);
                        this.val$recommendToMany.addDatum((double)(System.currentTimeMillis() - stepStart));
                    } else {
                        LoadRunner.this.client.recommend(userID, 10);
                        this.val$recommend.addDatum((double)(System.currentTimeMillis() - stepStart));
                    }
                }
                catch (TasteException te) {
                    log.warn("Error during request", (Throwable)te);
                }
                if (count % 1000L == 0L) {
                    log.info("Finished {} load steps", (Object)count);
                }
            }
        };
        log.info("Starting load test...");
        long start = System.currentTimeMillis();
        new Paralleler((Iterator)new CountingIterator(this.steps), (Processor)processor, "Load").runInParallel();
        long end = System.currentTimeMillis();
        log.info("Finished {} steps in {}ms", (Object)this.steps, (Object)(end - start));
        log.info("recommendedBecause: {}", (Object)recommendedBecause);
        log.info("setPreference: {}", (Object)setPreference);
        log.info("removePreference: {}", (Object)removePreference);
        log.info("setTag: {}", (Object)setTag);
        log.info("ingest: {}", (Object)ingest);
        log.info("refresh: {}", (Object)refresh);
        log.info("estimatePreference: {}", (Object)estimatePreference);
        log.info("mostSimilarItems: {}", (Object)mostSimilarItems);
        log.info("similarityToItem: {}", (Object)similarityToItem);
        log.info("mostPopularItems: {}", (Object)mostPopularItems);
        log.info("recommendToMany: {}", (Object)recommendToMany);
        log.info("recommend: {}", (Object)recommend);
    }
}

