/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixTest;
import org.junit.Test;

public final class LangUtilsTest
extends MyrrixTest {
    @Test(expected=IllegalArgumentException.class)
    public void testDoubleNaN() {
        LangUtils.parseDouble((String)"NaN");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFloatNaN() {
        LangUtils.parseFloat((String)"NaN");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDoubleInf() {
        LangUtils.parseDouble((String)"Infinity");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testFloatInf() {
        LangUtils.parseFloat((String)"Infinity");
    }

    @Test
    public void testDouble() {
        LangUtilsTest.assertEquals(3.1, LangUtils.parseDouble((String)"3.1"));
    }

    @Test
    public void testFloat() {
        LangUtilsTest.assertEquals(3.1f, LangUtils.parseFloat((String)"3.1"));
    }

    @Test
    public void testMod() {
        LangUtilsTest.assertEquals((long)0L, (long)LangUtils.mod((long)0L, (int)1));
        LangUtilsTest.assertEquals((long)0L, (long)LangUtils.mod((long)1L, (int)1));
        LangUtilsTest.assertEquals((long)0L, (long)LangUtils.mod((long)2L, (int)1));
        LangUtilsTest.assertEquals((long)1L, (long)LangUtils.mod((long)-1L, (int)2));
        LangUtilsTest.assertEquals((long)0L, (long)LangUtils.mod((long)0L, (int)2));
        LangUtilsTest.assertEquals((long)1L, (long)LangUtils.mod((long)1L, (int)2));
        LangUtilsTest.assertEquals((long)3L, (long)LangUtils.mod((long)7L, (int)4));
        LangUtilsTest.assertEquals((long)3L, (long)LangUtils.mod((long)-12L, (int)5));
        LangUtilsTest.assertEquals((long)0L, (long)LangUtils.mod((long)Long.MIN_VALUE, (int)64));
        LangUtilsTest.assertEquals((long)0L, (long)LangUtils.mod((long)0L, (int)64));
        LangUtilsTest.assertEquals((long)63L, (long)LangUtils.mod((long)Long.MAX_VALUE, (int)64));
    }
}

