/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.random;

import com.google.common.base.Preconditions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.myrrix.common.collection.FastIDSet;
import org.apache.commons.math3.random.RandomGenerator;
import org.apache.commons.math3.util.FastMath;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;

public final class RandomUtils {
    public static final int MAX_INT_SMALLER_TWIN_PRIME = 2147482949;
    private static final MessageDigest MD5_DIGEST;

    private RandomUtils() {
    }

    public static float[] randomUnitVector(int dimensions, RandomGenerator random) {
        float[] vector = new float[dimensions];
        double total = 0.0;
        for (int i = 0; i < dimensions; ++i) {
            double d = random.nextGaussian();
            vector[i] = (float)d;
            total += d * d;
        }
        float normalization = (float)FastMath.sqrt((double)total);
        int i = 0;
        while (i < dimensions) {
            int n = i++;
            vector[n] = vector[n] / normalization;
        }
        return vector;
    }

    public static int nextTwinPrime(int n) {
        if (n > 2147482949) {
            throw new IllegalArgumentException();
        }
        if (n <= 3) {
            return 5;
        }
        int next = RandomUtils.nextPrime(n);
        while (RandomUtils.isNotPrime(next + 2)) {
            next = RandomUtils.nextPrime(next + 4);
        }
        return next + 2;
    }

    private static int nextPrime(int n) {
        if (n <= 2) {
            return 2;
        }
        n |= 1;
        while (RandomUtils.isNotPrime(n)) {
            n += 2;
        }
        return n;
    }

    private static boolean isNotPrime(int n) {
        if (n < 2 || (n & 1) == 0) {
            return n != 2;
        }
        int max = 1 + (int)FastMath.sqrt((double)n);
        for (int d = 3; d <= max; d += 2) {
            if (n % d != 0) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long md5HashToLong(long l) {
        byte[] hash;
        MessageDigest messageDigest = MD5_DIGEST;
        synchronized (messageDigest) {
            for (int i = 0; i < 8; ++i) {
                MD5_DIGEST.update((byte)l);
                l >>= 8;
            }
            hash = MD5_DIGEST.digest();
        }
        long result = 0L;
        for (int i = 8; i < 16; ++i) {
            result = result << 4 | (long)hash[i] & 0xFFL;
        }
        return result;
    }

    public static int randomFrom(FastIDSet set, RandomGenerator random) {
        int size = set.size();
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0);
        LongPrimitiveIterator it = set.iterator();
        it.skip(random.nextInt(size));
        return (int)it.nextLong();
    }

    static {
        try {
            MD5_DIGEST = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

