/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.random;

import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.math3.random.MersenneTwister;
import org.apache.commons.math3.random.RandomGenerator;

public final class RandomManager {
    private static final long TEST_SEED = 1234567890L;
    private static final Map<RandomGenerator, Boolean> INSTANCES = new WeakHashMap<RandomGenerator, Boolean>();
    private static boolean useTestSeed = false;

    private RandomManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RandomGenerator getRandom() {
        if (useTestSeed) {
            return new MersenneTwister(1234567890L);
        }
        MersenneTwister random = new MersenneTwister();
        Map<RandomGenerator, Boolean> map = INSTANCES;
        synchronized (map) {
            INSTANCES.put((RandomGenerator)random, Boolean.TRUE);
        }
        return random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void useTestSeed() {
        useTestSeed = true;
        Map<RandomGenerator, Boolean> map = INSTANCES;
        synchronized (map) {
            for (RandomGenerator random : INSTANCES.keySet()) {
                random.setSeed(1234567890L);
            }
            INSTANCES.clear();
        }
    }
}

