/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.io;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayDeque;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public final class IOUtils {
    private IOUtils() {
    }

    public static boolean deleteRecursively(File dir) {
        if (dir == null) {
            return false;
        }
        ArrayDeque<File> stack = new ArrayDeque<File>();
        stack.push(dir);
        boolean result = true;
        while (!stack.isEmpty()) {
            File topElement = (File)stack.peek();
            if (topElement.isDirectory()) {
                File[] directoryContents = topElement.listFiles();
                if (directoryContents != null && directoryContents.length > 0) {
                    for (File fileOrSubDirectory : directoryContents) {
                        stack.push(fileOrSubDirectory);
                    }
                    continue;
                }
                result = result && ((File)stack.pop()).delete();
                continue;
            }
            result = result && ((File)stack.pop()).delete();
        }
        return result;
    }

    public static InputStream openMaybeDecompressing(File file) throws IOException {
        String name = file.getName();
        FileInputStream in = new FileInputStream(file);
        if (name.endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        if (name.endsWith(".zip")) {
            return new ZipInputStream(in);
        }
        if (name.endsWith(".deflate")) {
            return new DeflaterInputStream(in);
        }
        return in;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyStreamToFile(InputStream in, File file) throws IOException {
        FileOutputStream out = new FileOutputStream(file);
        try {
            ByteStreams.copy((InputStream)in, (OutputStream)out);
        }
        finally {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyURLToFile(URL url, File file) throws IOException {
        InputStream in = url.openStream();
        try {
            IOUtils.copyStreamToFile(in, file);
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readSmallTextFromURL(URL url) throws IOException {
        InputStreamReader in = new InputStreamReader(url.openStream(), Charsets.UTF_8);
        try {
            String string = CharStreams.toString((Readable)in);
            return string;
        }
        finally {
            Closeables.close((Closeable)in, (boolean)true);
        }
    }
}

