/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import net.myrrix.common.ByValueAscComparator;
import net.myrrix.common.MutableRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class TopN {
    private TopN() {
    }

    public static Queue<MutableRecommendedItem> initialQueue(int n) {
        return new PriorityQueue<RecommendedItem>(n + 2, ByValueAscComparator.INSTANCE);
    }

    public static void selectTopNIntoQueue(Queue<MutableRecommendedItem> topN, Iterator<RecommendedItem> values, int n) {
        while (values.hasNext()) {
            RecommendedItem value = values.next();
            if (value == null) continue;
            long itemID = value.getItemID();
            float valueScore = value.getValue();
            if (topN.size() > n) {
                if (!(valueScore > topN.peek().getValue())) continue;
                MutableRecommendedItem recycled = topN.poll();
                recycled.set(itemID, valueScore);
                topN.add(recycled);
                continue;
            }
            topN.add(new MutableRecommendedItem(itemID, valueScore));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void selectTopNIntoQueueMultithreaded(Queue<MutableRecommendedItem> topN, float[] queueLeastValue, Iterator<RecommendedItem> values, int n) {
        float localQueueLeastValue = queueLeastValue[0];
        while (values.hasNext()) {
            RecommendedItem value = values.next();
            if (value == null) continue;
            long itemID = value.getItemID();
            float valueScore = value.getValue();
            if (!(valueScore >= localQueueLeastValue)) continue;
            Queue<MutableRecommendedItem> queue = topN;
            synchronized (queue) {
                if (topN.size() > n) {
                    float currentQueueLeastValue;
                    localQueueLeastValue = currentQueueLeastValue = topN.peek().getValue();
                    if (valueScore > currentQueueLeastValue) {
                        MutableRecommendedItem recycled = topN.poll();
                        recycled.set(itemID, valueScore);
                        topN.add(recycled);
                    }
                } else {
                    topN.add(new MutableRecommendedItem(itemID, valueScore));
                }
            }
        }
        queueLeastValue[0] = localQueueLeastValue;
    }

    public static List<RecommendedItem> selectTopNFromQueue(Queue<MutableRecommendedItem> topN, int n) {
        if (topN.isEmpty()) {
            return Collections.emptyList();
        }
        while (topN.size() > n) {
            topN.poll();
        }
        ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>(topN);
        Collections.sort(result, Collections.reverseOrder(ByValueAscComparator.INSTANCE));
        return result;
    }

    public static List<RecommendedItem> selectTopN(Iterator<RecommendedItem> values, int n) {
        Queue<MutableRecommendedItem> topN = TopN.initialQueue(n);
        TopN.selectTopNIntoQueue(topN, values, n);
        return TopN.selectTopNFromQueue(topN, n);
    }
}

