/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class ReloadingReference<V> {
    public static final long NO_RELOAD = -1L;
    private V value;
    private final Callable<V> retriever;
    private long lastRetrieval;
    private final long durationMS;
    private final Lock lock;

    public ReloadingReference(Callable<V> retriever) {
        this(retriever, -1L, null);
    }

    public ReloadingReference(Callable<V> retriever, long duration, TimeUnit timeUnit) {
        Preconditions.checkNotNull(retriever);
        this.retriever = retriever;
        if (duration == -1L) {
            this.durationMS = -1L;
        } else {
            Preconditions.checkArgument((duration > 0L ? 1 : 0) != 0, (String)"Duration must be positive: %s", (Object[])new Object[]{duration});
            Preconditions.checkNotNull((Object)((Object)timeUnit));
            this.durationMS = TimeUnit.MILLISECONDS.convert(duration, timeUnit);
        }
        this.lock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(long timeout, TimeUnit timeUnit) {
        block5: {
            try {
                if (!this.lock.tryLock(timeout, timeUnit)) break block5;
                try {
                    this.doGet();
                }
                finally {
                    this.lock.unlock();
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
        }
        V theValue = this.value;
        return theValue == null ? this.get() : theValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get() {
        this.lock.lock();
        try {
            this.doGet();
        }
        finally {
            this.lock.unlock();
        }
        return this.value;
    }

    private void doGet() {
        long now;
        boolean reloading = this.durationMS > 0L;
        long l = now = reloading ? System.currentTimeMillis() : 0L;
        if (this.value == null || this.durationMS > 0L && now > this.lastRetrieval + this.durationMS) {
            try {
                this.value = this.retriever.call();
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
            this.lastRetrieval = now;
        }
    }

    public V maybeGet() {
        return this.value;
    }

    public void clear() {
        this.value = null;
    }
}

