/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.mahout.common.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class PartitionsUtils {
    private static final Logger log = LoggerFactory.getLogger(PartitionsUtils.class);
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern COLON = Pattern.compile(":");

    private PartitionsUtils() {
    }

    public static List<List<Pair<String, Integer>>> parseAllPartitions(CharSequence value) {
        if (value == null) {
            return null;
        }
        ArrayList allPartitions = Lists.newArrayList();
        for (String partitionString : SEMICOLON.split(value)) {
            ArrayList partition = Lists.newArrayList();
            for (String replicaString : COMMA.split(partitionString)) {
                String[] hostPort = COLON.split(replicaString);
                String host = hostPort[0];
                Integer port = Integer.valueOf(hostPort[1]);
                Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port must be positive: %s", (Object[])new Object[]{port});
                Pair replica = new Pair((Object)host, (Object)port);
                partition.add(replica);
            }
            Preconditions.checkArgument((!partition.isEmpty() ? 1 : 0) != 0, (Object)"At least one partition must be specified");
            allPartitions.add(partition);
        }
        PartitionsUtils.log(allPartitions);
        return allPartitions;
    }

    public static List<List<Pair<String, Integer>>> getDefaultLocalPartition(int port) {
        InetAddress localhost;
        try {
            localhost = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            throw new IllegalStateException(e);
        }
        String host = localhost.getHostName();
        return Collections.singletonList(Collections.singletonList(Pair.of((Object)host, (Object)port)));
    }

    public static List<List<Pair<String, Integer>>> parsePartitionsFromStatus(URL url) throws IOException {
        Document doc;
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IllegalStateException(e);
        }
        InputStreamReader reader = new InputStreamReader(url.openStream(), Charsets.UTF_8);
        try {
            doc = builder.parse(new InputSource(reader));
        }
        catch (SAXException saxe) {
            throw new IllegalStateException(saxe);
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)true);
        }
        Element docElement = doc.getDocumentElement();
        docElement.normalize();
        ArrayList result = Lists.newArrayList();
        NodeList partitionElements = docElement.getElementsByTagName("partition");
        for (int i = 0; i < partitionElements.getLength(); ++i) {
            ArrayList partitionResult = Lists.newArrayList();
            result.add(partitionResult);
            Element partitionElement = (Element)partitionElements.item(i);
            NodeList replicaElements = partitionElement.getElementsByTagName("replica");
            for (int j = 0; j < replicaElements.getLength(); ++j) {
                Node replicaElement = replicaElements.item(j);
                String[] hostPort = COLON.split(replicaElement.getTextContent());
                partitionResult.add(Pair.of((Object)hostPort[0], (Object)Integer.parseInt(hostPort[1])));
            }
        }
        return result;
    }

    private static void log(Collection<List<Pair<String, Integer>>> allPartitions) {
        if (allPartitions.isEmpty()) {
            log.info("No partitions parsed");
        } else {
            int partitionNumber = 0;
            for (List<Pair<String, Integer>> partition : allPartitions) {
                log.info("Partition {}: {}", (Object)partitionNumber, partition);
                ++partitionNumber;
            }
        }
    }
}

