/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Preconditions;

public final class LangUtils {
    private LangUtils() {
    }

    public static float parseFloat(String s) {
        float value = Float.parseFloat(s);
        Preconditions.checkArgument((boolean)LangUtils.isFinite(value), (String)"Bad value: %s", (Object[])new Object[]{Float.valueOf(value)});
        return value;
    }

    public static boolean isFinite(float f) {
        return !Float.isNaN(f) && !Float.isInfinite(f);
    }

    public static double parseDouble(String s) {
        double value = Double.parseDouble(s);
        Preconditions.checkArgument((boolean)LangUtils.isFinite(value), (String)"Bad value: %s", (Object[])new Object[]{value});
        return value;
    }

    public static boolean isFinite(double d) {
        return !Double.isNaN(d) && !Double.isInfinite(d);
    }

    public static int mod(long l, int m) {
        return ((int)(l % (long)m) + m) % m;
    }
}

