/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExecutorUtils {
    private static final Logger log = LoggerFactory.getLogger(ExecutorUtils.class);

    private ExecutorUtils() {
    }

    public static void shutdownNowAndAwait(ExecutorService executor) {
        if (!executor.isTerminated()) {
            if (!executor.isShutdown()) {
                executor.shutdownNow();
            }
            try {
                executor.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ie) {
                log.warn("Interrupted while shutting down executor");
            }
        }
    }
}

