/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLClassLoader;

public final class ClassUtils {
    private static final Class<?>[] NO_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    private ClassUtils() {
    }

    public static <T> T loadInstanceOf(Class<T> clazz) {
        return ClassUtils.loadInstanceOf(clazz.getName(), clazz);
    }

    public static <T> T loadInstanceOf(Class<T> clazz, Class<?>[] constructorTypes, Object[] constructorArgs) {
        return ClassUtils.loadInstanceOf(clazz.getName(), clazz, constructorTypes, constructorArgs);
    }

    public static <T> T loadInstanceOf(String implClassName, Class<T> superClass) {
        return ClassUtils.loadInstanceOf(implClassName, superClass, NO_TYPES, NO_ARGS);
    }

    public static <T> T loadInstanceOf(String implClassName, Class<T> superClass, Class<?>[] constructorTypes, Object[] constructorArgs) {
        return ClassUtils.doLoadInstanceOf(implClassName, superClass, constructorTypes, constructorArgs, ClassUtils.class.getClassLoader());
    }

    public static <T> T loadFromRemote(String implClassName, Class<T> superClass, URL url) {
        URLClassLoader urlClassloader = new URLClassLoader(new URL[]{url}, ClassUtils.class.getClassLoader());
        return ClassUtils.doLoadInstanceOf(implClassName, superClass, NO_TYPES, NO_ARGS, urlClassloader);
    }

    private static <T> T doLoadInstanceOf(String implClassName, Class<T> superClass, Class<?>[] constructorTypes, Object[] constructorArgs, ClassLoader classLoader) {
        try {
            Class<T> configClass = Class.forName(implClassName, true, classLoader).asSubclass(superClass);
            Constructor<T> constructor = configClass.getConstructor(constructorTypes);
            return constructor.newInstance(constructorArgs);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException("Could not instantiate " + superClass + " due to exception", ite.getCause());
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", iae);
        }
    }

    public static boolean classExists(String implClassName) {
        try {
            Class.forName(implClassName);
            return true;
        }
        catch (ClassNotFoundException cnfe) {
            return false;
        }
    }
}

