/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.stats;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.concurrent.TimeUnit;
import net.myrrix.common.stats.RunningAverageAndMinMax;
import net.myrrix.common.stats.RunningStatistics;
import net.myrrix.common.stats.WeightedRunningAverage;
import org.apache.mahout.cf.taste.impl.common.RunningAverage;

public final class RunningStatisticsPerTime
implements RunningAverageAndMinMax,
Serializable {
    private final WeightedRunningAverage average;
    private double min;
    private double max;
    private final long bucketTimeMS;
    private final LinkedList<RunningAverageAndMinMax> subBuckets;
    private long frontBucketValidUntil;

    public RunningStatisticsPerTime(TimeUnit timeUnit) {
        int timeUnitOrdinal = timeUnit.ordinal();
        Preconditions.checkArgument((timeUnitOrdinal >= TimeUnit.MINUTES.ordinal() ? 1 : 0) != 0);
        TimeUnit subTimeUnit = TimeUnit.values()[timeUnitOrdinal - 1];
        int numBuckets = (int)subTimeUnit.convert(1L, timeUnit);
        this.average = new WeightedRunningAverage();
        this.min = Double.NaN;
        this.max = Double.NaN;
        this.bucketTimeMS = TimeUnit.MILLISECONDS.convert(1L, subTimeUnit);
        this.subBuckets = new LinkedList();
        for (int i = 0; i < numBuckets; ++i) {
            this.subBuckets.add(new RunningStatistics());
        }
        this.frontBucketValidUntil = System.currentTimeMillis() + this.bucketTimeMS;
    }

    public synchronized void refresh() {
        long now = System.currentTimeMillis();
        while (now > this.frontBucketValidUntil) {
            RunningAverageAndMinMax removedBucket = this.subBuckets.removeLast();
            int count = removedBucket.getCount();
            if (count > 0) {
                this.average.removeDatum(removedBucket.getAverage(), count);
            }
            if (removedBucket.getMin() <= this.min) {
                double newMin = Double.NaN;
                for (RunningAverageAndMinMax bucket : this.subBuckets) {
                    double bucketMin = bucket.getMin();
                    if (!Double.isNaN(newMin) && !(bucketMin < newMin)) continue;
                    newMin = bucketMin;
                }
                this.min = newMin;
            }
            if (removedBucket.getMax() >= this.max) {
                double newMax = Double.NaN;
                for (RunningAverageAndMinMax bucket : this.subBuckets) {
                    double bucketMax = bucket.getMax();
                    if (!Double.isNaN(newMax) && !(bucketMax > newMax)) continue;
                    newMax = bucketMax;
                }
                this.max = newMax;
            }
            this.subBuckets.addFirst(new RunningStatistics());
            this.frontBucketValidUntil += this.bucketTimeMS;
        }
    }

    public synchronized void addDatum(double value) {
        this.refresh();
        this.average.addDatum(value);
        this.subBuckets.getFirst().addDatum(value);
        if (Double.isNaN(this.min) || value < this.min) {
            this.min = value;
        }
        if (Double.isNaN(this.max) || value > this.max) {
            this.max = value;
        }
    }

    public void removeDatum(double v) {
        throw new UnsupportedOperationException();
    }

    public void changeDatum(double v) {
        throw new UnsupportedOperationException();
    }

    public int getCount() {
        return this.average.getCount();
    }

    public double getAverage() {
        return this.average.getAverage();
    }

    public RunningAverage inverse() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized double getMin() {
        return this.min;
    }

    @Override
    public synchronized double getMax() {
        return this.max;
    }
}

