/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.log;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Queue;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public final class MemoryHandler
extends Handler {
    private static final int NUM_LINES = 1000;
    private final Queue<String> logLines = Lists.newLinkedList();

    public MemoryHandler() {
        this.setFormatter(new SimpleFormatter());
        this.setLevel(Level.FINE);
    }

    public Collection<String> getLogLines() {
        return this.logLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LogRecord logRecord) {
        String line = this.getFormatter().format(logRecord);
        Queue<String> queue = this.logLines;
        synchronized (queue) {
            this.logLines.add(line);
            for (int i = 0; i < this.logLines.size() - 1000; ++i) {
                this.logLines.remove();
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        this.logLines.clear();
    }
}

