/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common.io;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipInputStream;

public final class IOUtils {
    private IOUtils() {
    }

    public static void deleteRecursively(File dir) {
        new DeletingVisitor().accept(dir);
    }

    public static InputStream openMaybeDecompressing(File file) throws IOException {
        String name = file.getName();
        FileInputStream in = new FileInputStream(file);
        if (name.endsWith(".gz")) {
            return new GZIPInputStream(in);
        }
        if (name.endsWith(".zip")) {
            return new ZipInputStream(in);
        }
        if (name.endsWith(".deflate")) {
            return new DeflaterInputStream(in);
        }
        return in;
    }

    private static final class DeletingVisitor
    implements FileFilter {
        private DeletingVisitor() {
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (!f.isFile()) {
                    f.listFiles(this);
                }
                f.delete();
            }
            return false;
        }
    }
}

