/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.PriorityQueue;
import net.myrrix.common.ByValueAscComparator;
import net.myrrix.common.MutableRecommendedItem;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;

public final class TopN {
    private TopN() {
    }

    public static List<RecommendedItem> selectTopN(Iterator<RecommendedItem> values, int n) {
        PriorityQueue<RecommendedItem> topN = new PriorityQueue<RecommendedItem>(n + 2, ByValueAscComparator.INSTANCE);
        while (values.hasNext()) {
            RecommendedItem value = values.next();
            if (value == null) continue;
            long itemID = value.getItemID();
            if (topN.size() <= n) {
                topN.add(new MutableRecommendedItem(itemID, value.getValue()));
                continue;
            }
            float valueScore = value.getValue();
            if (!(valueScore > ((MutableRecommendedItem)topN.peek()).getValue())) continue;
            MutableRecommendedItem recycled = (MutableRecommendedItem)topN.poll();
            recycled.set(itemID, valueScore);
            topN.add(recycled);
        }
        if (topN.isEmpty()) {
            return Collections.emptyList();
        }
        while (topN.size() > n) {
            topN.poll();
        }
        ArrayList<RecommendedItem> result = new ArrayList<RecommendedItem>(topN);
        Collections.sort(result, Collections.reverseOrder(ByValueAscComparator.INSTANCE));
        return result;
    }
}

