/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public final class ClassUtils {
    private static final Class<?>[] NO_TYPES = new Class[0];
    private static final Object[] NO_ARGS = new Object[0];

    private ClassUtils() {
    }

    public static <T> T loadInstanceOf(Class<T> clazz) {
        return ClassUtils.loadInstanceOf(clazz.getName(), clazz);
    }

    public static <T> T loadInstanceOf(Class<T> clazz, Class<?>[] constructorTypes, Object[] constructorArgs) {
        return ClassUtils.loadInstanceOf(clazz.getName(), clazz, constructorTypes, constructorArgs);
    }

    public static <T> T loadInstanceOf(String implClassName, Class<T> superClass) {
        return ClassUtils.loadInstanceOf(implClassName, superClass, NO_TYPES, NO_ARGS);
    }

    public static <T> T loadInstanceOf(String implClassName, Class<T> superClass, Class<?>[] constructorTypes, Object[] constructorArgs) {
        try {
            Class<T> configClass = Class.forName(implClassName).asSubclass(superClass);
            Constructor<T> constructor = configClass.getConstructor(constructorTypes);
            return constructor.newInstance(constructorArgs);
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", cnfe);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", nsme);
        }
        catch (InvocationTargetException ite) {
            throw new IllegalStateException("Could not instantiate " + superClass + " due to exception", ite.getCause());
        }
        catch (InstantiationException ie) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", ie);
        }
        catch (IllegalAccessException iae) {
            throw new IllegalStateException("No valid " + superClass + " binding exists", iae);
        }
    }
}

