/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

public final class SimpleVectorMath {
    private SimpleVectorMath() {
    }

    public static double dot(float[] x, float[] y) {
        int length = x.length;
        double dot = 0.0;
        for (int i = 0; i < length; ++i) {
            dot += (double)(x[i] * y[i]);
        }
        return dot;
    }

    public static double norm(float[] x) {
        double total = 0.0;
        for (float f : x) {
            total += (double)(f * f);
        }
        return Math.sqrt(total);
    }

    public static double correlation(float[] x, float[] y) {
        double sumX = 0.0;
        double sumY = 0.0;
        double sumX2 = 0.0;
        double sumY2 = 0.0;
        double sumXY = 0.0;
        int n = x.length;
        for (int i = 0; i < n; ++i) {
            double xValue = x[i];
            double yValue = y[i];
            sumX += xValue;
            sumY += yValue;
            sumX2 += xValue * xValue;
            sumY2 += yValue * yValue;
            sumXY += xValue * yValue;
        }
        return ((double)n * sumXY - sumX * sumY) / Math.sqrt(((double)n * sumX2 - sumX * sumX) * ((double)n * sumY2 - sumY * sumY));
    }

    public static double cosineMeasure(float[] x, float[] y) {
        return SimpleVectorMath.dot(x, y) / (SimpleVectorMath.norm(x) * SimpleVectorMath.norm(y));
    }
}

