/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.util.concurrent.atomic.AtomicInteger;
import net.myrrix.common.RunningAverageAndMinMax;
import org.apache.mahout.cf.taste.impl.common.FullRunningAverageAndStdDev;
import org.apache.mahout.cf.taste.impl.common.RunningAverageAndStdDev;

public final class RunningStatistics
implements RunningAverageAndStdDev,
RunningAverageAndMinMax {
    private final RunningAverageAndStdDev delegate;
    private double min;
    private double max;
    private final AtomicInteger numClientErrors;
    private final AtomicInteger numServerErrors;

    public RunningStatistics() {
        this((RunningAverageAndStdDev)new FullRunningAverageAndStdDev(), Double.NaN, Double.NaN);
    }

    private RunningStatistics(RunningAverageAndStdDev delegate, double min, double max) {
        this.delegate = delegate;
        this.min = min;
        this.max = max;
        this.numClientErrors = new AtomicInteger();
        this.numServerErrors = new AtomicInteger();
    }

    public int getCount() {
        return this.delegate.getCount();
    }

    public double getAverage() {
        return this.delegate.getAverage();
    }

    public double getStandardDeviation() {
        return this.delegate.getStandardDeviation();
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    public void addDatum(double v) {
        this.delegate.addDatum(v);
        if (Double.isNaN(this.max) || v > this.max) {
            this.max = v;
        }
        if (Double.isNaN(this.min) || v < this.min) {
            this.min = v;
        }
    }

    public void removeDatum(double v) {
        throw new UnsupportedOperationException();
    }

    public void changeDatum(double v) {
        throw new UnsupportedOperationException();
    }

    public RunningAverageAndStdDev inverse() {
        return new RunningStatistics(this.delegate.inverse(), -this.max, -this.min);
    }

    public int getNumClientErrors() {
        return this.numClientErrors.get();
    }

    public void incrementClientErrors() {
        this.numClientErrors.incrementAndGet();
    }

    public int getNumServerErrors() {
        return this.numServerErrors.get();
    }

    public void incrementServerErrors() {
        this.numServerErrors.incrementAndGet();
    }
}

