/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.mahout.common.Pair;

public final class PartitionsUtils {
    private static final Pattern SEMICOLON = Pattern.compile(";");
    private static final Pattern COMMA = Pattern.compile(",");
    private static final Pattern COLON = Pattern.compile(":");

    private PartitionsUtils() {
    }

    public static List<List<Pair<String, Integer>>> parseAllPartitions(CharSequence value) {
        if (value == null) {
            return null;
        }
        ArrayList allPartitions = Lists.newArrayList();
        for (String partitionString : SEMICOLON.split(value)) {
            ArrayList partition = Lists.newArrayList();
            for (String replicaString : COMMA.split(partitionString)) {
                String[] hostPort = COLON.split(replicaString);
                String host = hostPort[0];
                Integer port = Integer.valueOf(hostPort[1]);
                Preconditions.checkArgument((port > 0 ? 1 : 0) != 0);
                Pair replica = new Pair((Object)host, (Object)port);
                partition.add(replica);
            }
            Preconditions.checkArgument((!partition.isEmpty() ? 1 : 0) != 0);
            allPartitions.add(partition);
        }
        return allPartitions;
    }
}

