/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.common;

import java.net.InetAddress;
import java.net.UnknownHostException;

public final class JVMEnvironment {
    private static final String UNKNOWN_HOST = "Unknown";
    private final Runtime runtime = Runtime.getRuntime();
    private String hostName;

    public int getNumProcessors() {
        return this.runtime.availableProcessors();
    }

    public int getUsedMemoryMB() {
        return (int)((this.runtime.totalMemory() - this.runtime.freeMemory()) / 1000000L);
    }

    public int getMaxMemoryMB() {
        return (int)(this.runtime.maxMemory() / 1000000L);
    }

    public int getPercentUsedMemory() {
        return 100 * this.getUsedMemoryMB() / this.getMaxMemoryMB();
    }

    public String getHostName() {
        if (this.hostName == null || UNKNOWN_HOST.equals(this.hostName)) {
            try {
                this.hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException uhe) {
                this.hostName = UNKNOWN_HOST;
            }
        }
        return this.hostName;
    }

    public String toString() {
        return this.hostName + " : " + this.getNumProcessors() + " processors, " + this.getUsedMemoryMB() + "MB used of " + this.getMaxMemoryMB() + "MB";
    }
}

