/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client.translating;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import net.myrrix.client.ClientRecommender;
import net.myrrix.client.translating.GenericTranslatedRecommendedItem;
import net.myrrix.client.translating.TranslatedRecommendedItem;
import net.myrrix.client.translating.TranslatingRecommender;
import net.myrrix.common.OneWayMigrator;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.iterator.FileLineIterable;
import net.myrrix.common.random.MemoryIDMigrator;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.model.IDMigrator;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslatingClientRecommender
implements TranslatingRecommender {
    private static final Logger log = LoggerFactory.getLogger(TranslatingClientRecommender.class);
    private static final Splitter COMMA_SPLIT = Splitter.on((char)',');
    private static final Joiner COMMA_JOIN = Joiner.on((char)',');
    private final IDMigrator userTranslator;
    private final MemoryIDMigrator itemTranslator;
    private final ClientRecommender delegate;

    public TranslatingClientRecommender(ClientRecommender delegate) {
        this(delegate, (IDMigrator)new OneWayMigrator(), new MemoryIDMigrator());
    }

    public TranslatingClientRecommender(ClientRecommender delegate, IDMigrator userTranslator, MemoryIDMigrator itemTranslator) {
        this.delegate = delegate;
        this.userTranslator = userTranslator;
        this.itemTranslator = itemTranslator;
    }

    private long translateUser(String userID) {
        return this.userTranslator == null ? Long.parseLong(userID) : this.userTranslator.toLongID(userID);
    }

    private long translateItem(String itemID) {
        return this.itemTranslator == null ? Long.parseLong(itemID) : this.itemTranslator.toLongID(itemID);
    }

    private String untranslateItem(long itemID) {
        return this.itemTranslator == null ? Long.toString(itemID) : this.itemTranslator.toStringID(itemID);
    }

    private long[] translateUsers(String ... userIDs) {
        long[] translated = new long[userIDs.length];
        for (int i = 0; i < userIDs.length; ++i) {
            translated[i] = this.translateUser(userIDs[i]);
        }
        return translated;
    }

    private long[] translateItems(String ... itemIDs) {
        long[] translated = new long[itemIDs.length];
        for (int i = 0; i < itemIDs.length; ++i) {
            translated[i] = this.translateItem(itemIDs[i]);
        }
        return translated;
    }

    @Override
    public List<TranslatedRecommendedItem> recommend(String userID, int howMany) throws TasteException {
        long longUserID = this.translateUser(userID);
        List<RecommendedItem> originals = this.delegate.recommend(longUserID, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommend(String userID, int howMany, boolean considerKnownItems, String[] rescorerParams) throws TasteException {
        long longUserID = this.translateUser(userID);
        List<RecommendedItem> originals = this.delegate.recommend(longUserID, howMany, considerKnownItems, rescorerParams);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendToMany(String[] userIDs, int howMany, boolean considerKnownItems, String[] rescorerParams) throws TasteException {
        long[] longUserIDs = this.translateUsers(userIDs);
        List<RecommendedItem> originals = this.delegate.recommendToMany(longUserIDs, howMany, considerKnownItems, rescorerParams);
        return this.translate(originals);
    }

    @Override
    public float estimatePreference(String userID, String itemID) throws TasteException {
        long longUserID = this.translateUser(userID);
        long longItemID = this.translateItem(itemID);
        return this.delegate.estimatePreference(longUserID, longItemID);
    }

    @Override
    public float[] estimatePreferences(String userID, String ... itemIDs) throws TasteException {
        long longUserID = this.translateUser(userID);
        long[] longItemIDs = this.translateItems(itemIDs);
        return this.delegate.estimatePreferences(longUserID, longItemIDs);
    }

    @Override
    public float estimateForAnonymous(String toItemID, String[] itemIDs) throws TasteException {
        long[] longItemIDs = this.translateItems(itemIDs);
        long longToItemID = this.translateItem(toItemID);
        return this.delegate.estimateForAnonymous(longToItemID, longItemIDs);
    }

    @Override
    public float estimateForAnonymous(String toItemID, String[] itemIDs, float[] values) throws TasteException {
        long[] longItemIDs = this.translateItems(itemIDs);
        long longToItemID = this.translateItem(toItemID);
        return this.delegate.estimateForAnonymous(longToItemID, longItemIDs, values);
    }

    @Override
    public void setPreference(String userID, String itemID) throws TasteException {
        long longUserID = this.translateUser(userID);
        long longItemID = this.translateItem(itemID);
        this.delegate.setPreference(longUserID, longItemID);
    }

    @Override
    public void setPreference(String userID, String itemID, float value) throws TasteException {
        long longUserID = this.translateUser(userID);
        long longItemID = this.translateItem(itemID);
        this.delegate.setPreference(longUserID, longItemID, value);
    }

    @Override
    public void removePreference(String userID, String itemID) throws TasteException {
        long longUserID = this.translateUser(userID);
        long longItemID = this.translateItem(itemID);
        this.delegate.removePreference(longUserID, longItemID);
    }

    @Override
    public void setUserTag(String userID, String tag) throws TasteException {
        long longUserID = this.translateUser(userID);
        this.delegate.setUserTag(longUserID, tag);
    }

    @Override
    public void setUserTag(String userID, String tag, float value) throws TasteException {
        long longUserID = this.translateUser(userID);
        this.delegate.setUserTag(longUserID, tag, value);
    }

    @Override
    public void setItemTag(String tag, String itemID) throws TasteException {
        long longItemID = this.translateItem(itemID);
        this.delegate.setItemTag(tag, longItemID);
    }

    @Override
    public void setItemTag(String tag, String itemID, float value) throws TasteException {
        long longItemID = this.translateItem(itemID);
        this.delegate.setItemTag(tag, longItemID, value);
    }

    @Override
    public List<TranslatedRecommendedItem> mostSimilarItems(String itemID, int howMany) throws TasteException {
        long longItemID = this.translateItem(itemID);
        List<RecommendedItem> originals = this.delegate.mostSimilarItems(longItemID, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> mostSimilarItems(String[] itemIDs, int howMany) throws TasteException {
        return this.mostSimilarItems(itemIDs, howMany, null, null);
    }

    @Override
    public List<TranslatedRecommendedItem> mostSimilarItems(String[] itemIDs, int howMany, String[] rescorerParams, String contextUserID) throws TasteException {
        long[] longItemIDs = this.translateItems(itemIDs);
        List<RecommendedItem> originals = contextUserID == null ? this.delegate.mostSimilarItems(longItemIDs, howMany, rescorerParams, null) : this.delegate.mostSimilarItems(longItemIDs, howMany, rescorerParams, this.translateUser(contextUserID));
        return this.translate(originals);
    }

    @Override
    public float[] similarityToItem(String toItemID, String ... itemIDs) throws TasteException {
        return this.similarityToItem(toItemID, itemIDs, (String)null);
    }

    @Override
    public float[] similarityToItem(String toItemID, String[] itemIDs, String contextUserID) throws TasteException {
        long longToItemID = this.translateItem(toItemID);
        long[] longItemIDs = this.translateItems(itemIDs);
        Long longContextUserID = contextUserID == null ? null : Long.valueOf(contextUserID);
        return this.delegate.similarityToItem(longToItemID, longItemIDs, longContextUserID);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendedBecause(String userID, String itemID, int howMany) throws TasteException {
        long longUserID = this.translateUser(userID);
        long longItemID = this.translateItem(itemID);
        List<RecommendedItem> originals = this.delegate.recommendedBecause(longUserID, longItemID, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendToAnonymous(String[] itemIDs, int howMany) throws TasteException {
        return this.recommendToAnonymous(itemIDs, null, howMany, null, null);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendToAnonymous(String[] itemIDs, float[] values, int howMany) throws TasteException {
        return this.recommendToAnonymous(itemIDs, values, howMany, null, null);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendToAnonymous(String[] itemIDs, float[] values, int howMany, String[] rescorerParams, String contextUserID) throws TasteException {
        long[] longItemIDs = this.translateItems(itemIDs);
        List<RecommendedItem> originals = contextUserID == null ? this.delegate.recommendToAnonymous(longItemIDs, values, howMany, rescorerParams, null) : this.delegate.recommendToAnonymous(longItemIDs, values, howMany, rescorerParams, this.translateUser(contextUserID));
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> mostPopularItems(int howMany) throws TasteException {
        return this.translate(this.delegate.mostPopularItems(howMany));
    }

    @Override
    public void ingest(Reader reader) throws TasteException {
        File tempFile = null;
        try {
            tempFile = this.copyAndTranslateToTempFile(reader);
            this.delegate.ingest(tempFile);
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
        finally {
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                log.warn("Could not delete {}", (Object)tempFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyAndTranslateToTempFile(Reader reader) throws IOException {
        File tempFile = File.createTempFile("myrrix-", ".csv.gz");
        tempFile.deleteOnExit();
        log.debug("Translating ingest input to {}", (Object)tempFile);
        Closer closer = Closer.create();
        try {
            String line;
            BufferedReader buffered = (BufferedReader)closer.register((Closeable)IOUtils.buffer((Reader)reader));
            Writer out = (Writer)closer.register((Closeable)IOUtils.buildGZIPWriter((File)tempFile));
            while ((line = buffered.readLine()) != null) {
                String translatedLine;
                Iterator it = COMMA_SPLIT.split((CharSequence)line).iterator();
                String userIDString = (String)it.next();
                String itemIDString = (String)it.next();
                long longUserID = this.translateUser(userIDString);
                long longItemID = this.translateItem(itemIDString);
                if (it.hasNext()) {
                    String valueString = (String)it.next();
                    translatedLine = COMMA_JOIN.join((Object)longUserID, (Object)longItemID, new Object[]{valueString});
                } else {
                    translatedLine = COMMA_JOIN.join((Object)longUserID, (Object)longItemID, new Object[0]);
                }
                out.write(translatedLine);
                out.write(10);
            }
        }
        finally {
            closer.close();
        }
        log.debug("Done translating ingest input to {}", (Object)tempFile);
        return tempFile;
    }

    @Override
    public void ingest(File file) throws TasteException {
        Reader reader = null;
        try {
            reader = IOUtils.openReaderMaybeDecompressing((File)file);
            this.ingest(reader);
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
        finally {
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException e) {}
        }
    }

    @Override
    public void addItemIDs(Iterable<String> ids) {
        if (this.itemTranslator != null) {
            this.itemTranslator.initialize(ids);
        }
    }

    @Override
    public void addItemIDs(File idFile) throws TasteException {
        try {
            this.addItemIDs((Iterable<String>)new FileLineIterable(idFile));
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
    }

    @Override
    public boolean isReady() throws TasteException {
        return this.delegate.isReady();
    }

    @Override
    public void refresh() {
        this.delegate.refresh();
    }

    @Override
    public void await() throws TasteException, InterruptedException {
        this.delegate.await();
    }

    @Override
    public boolean await(long time, TimeUnit unit) throws TasteException, InterruptedException {
        return this.delegate.await(time, unit);
    }

    @Override
    public Collection<String> getAllItemIDs() throws TasteException {
        return this.translate(this.delegate.getAllItemIDs());
    }

    @Override
    public int getNumUserClusters() throws TasteException {
        return this.delegate.getNumUserClusters();
    }

    @Override
    public int getNumItemClusters() throws TasteException {
        return this.delegate.getNumItemClusters();
    }

    @Override
    public Collection<String> getUserCluster(int n) throws TasteException {
        FastIDSet userIDs = this.delegate.getUserCluster(n);
        ArrayList translated = Lists.newArrayListWithCapacity((int)userIDs.size());
        LongPrimitiveIterator it = userIDs.iterator();
        while (it.hasNext()) {
            translated.add(Long.toString(it.nextLong()));
        }
        return translated;
    }

    @Override
    public Collection<String> getItemCluster(int n) throws TasteException {
        return this.translate(this.delegate.getItemCluster(n));
    }

    private List<TranslatedRecommendedItem> translate(Collection<RecommendedItem> originals) {
        ArrayList translated = Lists.newArrayListWithCapacity((int)originals.size());
        for (RecommendedItem original : originals) {
            long id = original.getItemID();
            String untranslation = this.untranslateItem(id);
            String translatedItemID = untranslation == null ? Long.toString(id) : untranslation;
            translated.add(new GenericTranslatedRecommendedItem(translatedItemID, original.getValue()));
        }
        return translated;
    }

    private Collection<String> translate(FastIDSet itemIDs) {
        ArrayList result = Lists.newArrayListWithCapacity((int)itemIDs.size());
        LongPrimitiveIterator it = itemIDs.iterator();
        while (it.hasNext()) {
            result.add(this.untranslateItem(it.nextLong()));
        }
        return result;
    }
}

