/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import com.google.common.base.Preconditions;
import com.google.common.net.HostAndPort;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.myrrix.common.PartitionsUtils;

public final class MyrrixClientConfiguration {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = 80;
    public static final String AUTO_PARTITION_SPEC = "auto";
    private String host = "localhost";
    private int port = 80;
    private boolean secure;
    private String contextPath;
    private File keystoreFile;
    private String keystorePassword;
    private String userName;
    private String password;
    private String allPartitionsSpecification;
    private List<List<HostAndPort>> partitions;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        Preconditions.checkArgument((host == null || !host.startsWith("http://") && !host.startsWith("https://") ? 1 : 0) != 0, (String)"host should not include a URI scheme: %s", (Object[])new Object[]{host});
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        Preconditions.checkArgument((port > 0 ? 1 : 0) != 0, (String)"port must be positive: %s", (Object[])new Object[]{port});
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public File getKeystoreFile() {
        return this.keystoreFile;
    }

    public void setKeystoreFile(File keystoreFile) {
        this.keystoreFile = keystoreFile;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public void setKeystorePassword(String keystorePassword) {
        this.keystorePassword = keystorePassword;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAllPartitionsSpecification() {
        return this.allPartitionsSpecification;
    }

    public void setAllPartitionsSpecification(String allPartitionsSpecification) {
        this.allPartitionsSpecification = allPartitionsSpecification;
        if (AUTO_PARTITION_SPEC.equals(allPartitionsSpecification)) {
            try {
                this.partitions = this.parseAutoPartitionSpecification();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        } else {
            this.partitions = PartitionsUtils.parseAllPartitions((CharSequence)allPartitionsSpecification);
        }
    }

    private List<List<HostAndPort>> parseAutoPartitionSpecification() throws IOException {
        URL statusURL;
        String scheme = this.isSecure() ? "https" : "http";
        String path = this.contextPath == null ? "/status.jspx" : '/' + this.contextPath + "/status.jspx";
        try {
            statusURL = new URL(scheme, this.host, this.port, path);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        return PartitionsUtils.parsePartitionsFromStatus((URL)statusURL);
    }

    public List<List<HostAndPort>> getPartitions() {
        return this.partitions == null ? Collections.singletonList(Collections.singletonList(HostAndPort.fromParts((String)this.host, (int)this.port))) : this.partitions;
    }
}

