/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.common.net.HostAndPort;
import com.google.common.net.MediaType;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import net.myrrix.client.MyrrixClientConfiguration;
import net.myrrix.common.LangUtils;
import net.myrrix.common.MyrrixRecommender;
import net.myrrix.common.NotReadyException;
import net.myrrix.common.collection.FastIDSet;
import net.myrrix.common.io.IOUtils;
import net.myrrix.common.random.RandomUtils;
import org.apache.commons.math3.util.FastMath;
import org.apache.commons.math3.util.Pair;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.recommender.GenericRecommendedItem;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Rescorer;
import org.apache.mahout.common.LongPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRecommender
implements MyrrixRecommender {
    private static final Logger log = LoggerFactory.getLogger(ClientRecommender.class);
    private static final Splitter COMMA = Splitter.on((char)',');
    private static final String IGNORE_HOSTNAME_KEY = "client.https.ignoreHost";
    private static final String CONNECTION_CLOSE_KEY = "client.connection.close";
    private static final Map<String, String> INGEST_REQUEST_PROPS = Maps.newHashMapWithExpectedSize((int)2);
    private static final String DESIRED_RESPONSE_CONTENT_TYPE;
    private final MyrrixClientConfiguration config;
    private final boolean needAuthentication;
    private final boolean closeConnection;
    private final boolean ignoreHTTPSHost;
    private final List<List<HostAndPort>> partitions;

    public ClientRecommender(MyrrixClientConfiguration config) throws IOException {
        Preconditions.checkNotNull((Object)config);
        this.config = config;
        final String userName = config.getUserName();
        final String password = config.getPassword();
        boolean bl = this.needAuthentication = userName != null && password != null;
        if (this.needAuthentication) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(userName, password.toCharArray());
                }
            });
        }
        if (config.getKeystoreFile() != null) {
            log.warn("A keystore file has been specified. This should only be done to accept self-signed certificates in development.");
            HttpsURLConnection.setDefaultSSLSocketFactory(this.buildSSLSocketFactory());
        }
        this.closeConnection = Boolean.valueOf(System.getProperty(CONNECTION_CLOSE_KEY));
        this.ignoreHTTPSHost = Boolean.valueOf(System.getProperty(IGNORE_HOSTNAME_KEY));
        this.partitions = config.getPartitions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLSocketFactory buildSSLSocketFactory() throws IOException {
        final HostnameVerifier defaultVerifier = HttpsURLConnection.getDefaultHostnameVerifier();
        HttpsURLConnection.setDefaultHostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession sslSession) {
                return ClientRecommender.this.ignoreHTTPSHost || "localhost".equals(hostname) || "127.0.0.1".equals(hostname) || defaultVerifier.verify(hostname, sslSession);
            }
        });
        try {
            SSLContext ctx;
            TrustManagerFactory tmf;
            block11: {
                KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                File trustStoreFile = this.config.getKeystoreFile().getAbsoluteFile();
                String password = this.config.getKeystorePassword();
                Preconditions.checkNotNull((Object)password);
                FileInputStream in = new FileInputStream(trustStoreFile);
                try {
                    keyStore.load(in, password.toCharArray());
                }
                finally {
                    Closeables.close((Closeable)in, (boolean)true);
                }
                tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(keyStore);
                try {
                    ctx = SSLContext.getInstance("TLSv1.1");
                }
                catch (NoSuchAlgorithmException ignored) {
                    log.info("TLSv1.1 unavailable, falling back to TLSv1");
                    ctx = SSLContext.getInstance("TLSv1");
                    if (System.getProperty("https.protocols") != null) break block11;
                    System.setProperty("https.protocols", "TLSv1");
                }
            }
            ctx.init(null, tmf.getTrustManagers(), null);
            return ctx.getSocketFactory();
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new IllegalStateException(nsae);
        }
        catch (KeyStoreException kse) {
            throw new IOException(kse);
        }
        catch (KeyManagementException kme) {
            throw new IOException(kme);
        }
        catch (CertificateException ce) {
            throw new IOException(ce);
        }
    }

    private HttpURLConnection buildConnectionToReplica(HostAndPort replica, String path, String method) throws IOException {
        return this.buildConnectionToReplica(replica, path, method, false, false, null);
    }

    private HttpURLConnection buildConnectionToReplica(HostAndPort replica, String path, String method, boolean doOutput, boolean chunkedStreaming, Map<String, String> requestProperties) throws IOException {
        URL url;
        String contextPath = this.config.getContextPath();
        if (contextPath != null) {
            path = '/' + contextPath + path;
        }
        String protocol = this.config.isSecure() ? "https" : "http";
        try {
            url = new URL(protocol, replica.getHostText(), replica.getPort(), path);
        }
        catch (MalformedURLException mue) {
            throw new IllegalStateException(mue);
        }
        log.debug("{} {}", (Object)method, (Object)url);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(method);
        connection.setDoInput(true);
        connection.setDoOutput(doOutput);
        connection.setUseCaches(false);
        connection.setAllowUserInteraction(false);
        connection.setRequestProperty("Accept", DESIRED_RESPONSE_CONTENT_TYPE);
        if (this.closeConnection) {
            connection.setRequestProperty("Connection", "close");
        }
        if (chunkedStreaming) {
            if (this.needAuthentication) {
                log.debug("Authentication is enabled, so ingest data must be buffered in memory");
            } else {
                connection.setChunkedStreamingMode(0);
            }
        }
        if (requestProperties != null) {
            for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return connection;
    }

    private Iterable<HostAndPort> choosePartitionAndReplicas(long unnormalizedID) {
        List<HostAndPort> replicas = this.partitions.get(LangUtils.mod((long)unnormalizedID, (int)this.partitions.size()));
        int numReplicas = replicas.size();
        if (numReplicas <= 1) {
            return replicas;
        }
        int currentReplica = LangUtils.mod((long)RandomUtils.md5HashToLong((long)unnormalizedID), (int)numReplicas);
        ArrayList rotatedReplicas = Lists.newArrayListWithCapacity((int)numReplicas);
        for (int i = 0; i < numReplicas; ++i) {
            rotatedReplicas.add(replicas.get(currentReplica));
            if (++currentReplica != numReplicas) continue;
            currentReplica = 0;
        }
        return rotatedReplicas;
    }

    public void setPreference(long userID, long itemID) throws TasteException {
        this.setPreference(userID, itemID, 1.0f);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.doSetOrRemovePreference(userID, itemID, value, true);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.doSetOrRemovePreference(userID, itemID, 1.0f, false);
    }

    private void doSetOrRemovePreference(long userID, long itemID, float value, boolean set) throws TasteException {
        this.doSetOrRemove("/pref/" + userID + '/' + itemID, userID, value, set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSetOrRemove(String path, long unnormalizedID, float value, boolean set) throws TasteException {
        byte[] bytes;
        HashMap requestProperties;
        boolean sendValue;
        boolean bl = sendValue = value != 1.0f;
        if (sendValue) {
            requestProperties = Maps.newHashMapWithExpectedSize((int)2);
            bytes = Float.toString(value).getBytes(Charsets.UTF_8);
            requestProperties.put("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString());
            requestProperties.put("Content-Length", Integer.toString(bytes.length));
        } else {
            requestProperties = null;
            bytes = null;
        }
        TasteException savedException = null;
        for (HostAndPort replica : this.choosePartitionAndReplicas(unnormalizedID)) {
            HttpURLConnection connection = null;
            try {
                connection = this.buildConnectionToReplica(replica, path, set ? "POST" : "DELETE", sendValue, false, requestProperties);
                if (sendValue) {
                    OutputStream out = connection.getOutputStream();
                    out.write(bytes);
                    out.close();
                }
                if (connection.getResponseCode() != 200) {
                    throw new TasteException(connection.getResponseCode() + " " + connection.getResponseMessage());
                }
                return;
            }
            catch (TasteException te) {
                log.info("Can't access {} at {}: ({})", new Object[]{path, replica, te.toString()});
                savedException = te;
            }
            catch (IOException ioe) {
                log.info("Can't access {} at {}: ({})", new Object[]{path, replica, ioe.toString()});
                savedException = new TasteException((Throwable)ioe);
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
        throw savedException;
    }

    public void setUserTag(long userID, String tag) throws TasteException {
        this.setUserTag(userID, tag, 1.0f);
    }

    public void setUserTag(long userID, String tag, float value) throws TasteException {
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0);
        this.doSetOrRemove("/tag/user/" + userID + '/' + IOUtils.urlEncode((String)tag), userID, value, true);
    }

    public void setItemTag(String tag, long itemID) throws TasteException {
        this.setItemTag(tag, itemID, 1.0f);
    }

    public void setItemTag(String tag, long itemID, float value) throws TasteException {
        this.setItemTag(tag, itemID, value, null);
    }

    public void setItemTag(String tag, long itemID, float value, Long contextUserID) throws TasteException {
        Preconditions.checkNotNull((Object)tag);
        Preconditions.checkArgument((!tag.isEmpty() ? 1 : 0) != 0);
        long idToPartitionOn = contextUserID == null ? itemID : contextUserID;
        this.doSetOrRemove("/tag/item/" + itemID + '/' + IOUtils.urlEncode((String)tag), idToPartitionOn, value, true);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.estimatePreferences(userID, itemID)[0];
    }

    /*
     * Exception decompiling
     */
    public float[] estimatePreferences(long userID, long ... itemIDs) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE], 9[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public float estimateForAnonymous(long toItemID, long[] itemIDs) throws TasteException {
        return this.estimateForAnonymous(toItemID, itemIDs, null);
    }

    public float estimateForAnonymous(long toItemID, long[] itemIDs, float[] values) throws TasteException {
        return this.estimateForAnonymous(toItemID, itemIDs, values, null);
    }

    /*
     * Exception decompiling
     */
    public float estimateForAnonymous(long toItemID, long[] itemIDs, float[] values, Long contextUserID) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 6[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommend(userID, howMany, false, (String[])null);
    }

    /*
     * Exception decompiling
     */
    public List<RecommendedItem> recommend(long userID, int howMany, boolean considerKnownItems, String[] rescorerParams) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<RecommendedItem> consumeItems(HttpURLConnection connection) throws IOException {
        ArrayList result = Lists.newArrayList();
        BufferedReader reader = IOUtils.bufferStream((InputStream)connection.getInputStream());
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                Iterator tokens = COMMA.split((CharSequence)line).iterator();
                long itemID = Long.parseLong((String)tokens.next());
                float value = LangUtils.parseFloat((String)((String)tokens.next()));
                result.add(new GenericRecommendedItem(itemID, value));
            }
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)true);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public List<RecommendedItem> recommendToMany(long[] userIDs, int howMany, boolean considerKnownItems, String[] rescorerParams) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, int howMany) throws TasteException {
        return this.recommendToAnonymous(itemIDs, null, howMany);
    }

    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, float[] values, int howMany) throws TasteException {
        return this.recommendToAnonymous(itemIDs, values, howMany, null, null);
    }

    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, float[] values, int howMany, String[] rescorerParams, Long contextUserID) throws TasteException {
        return this.anonymousOrSimilar(itemIDs, values, howMany, "/recommendToAnonymous", rescorerParams, contextUserID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<RecommendedItem> mostPopularItems(int howMany) throws TasteException {
        StringBuilder urlPath = new StringBuilder(32);
        urlPath.append("/mostPopularItems");
        ClientRecommender.appendCommonQueryParams(howMany, false, null, urlPath);
        TasteException savedException = null;
        Iterator<HostAndPort> i$ = this.choosePartitionAndReplicas(0L).iterator();
        while (i$.hasNext()) {
            HostAndPort replica = i$.next();
            HttpURLConnection connection = null;
            try {
                connection = this.buildConnectionToReplica(replica, urlPath.toString(), "GET");
                switch (connection.getResponseCode()) {
                    case 200: {
                        List<RecommendedItem> list = ClientRecommender.consumeItems(connection);
                        if (connection == null) return list;
                        connection.disconnect();
                        return list;
                    }
                    case 503: {
                        throw new NotReadyException();
                    }
                    default: {
                        throw new TasteException(connection.getResponseCode() + " " + connection.getResponseMessage());
                    }
                }
            }
            catch (TasteException te) {
                log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, te.toString()});
                savedException = te;
                if (connection == null) continue;
                connection.disconnect();
            }
            catch (IOException ioe) {
                try {
                    log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, ioe.toString()});
                    savedException = new TasteException((Throwable)ioe);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (connection == null) continue;
                    connection.disconnect();
                }
            }
        }
        throw savedException;
    }

    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany) throws TasteException {
        return this.mostSimilarItems(itemIDs, howMany, null, null);
    }

    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, String[] rescorerParams, Long contextUserID) throws TasteException {
        return this.anonymousOrSimilar(itemIDs, null, howMany, "/similarity", rescorerParams, contextUserID);
    }

    /*
     * Exception decompiling
     */
    private List<RecommendedItem> anonymousOrSimilar(long[] itemIDs, float[] values, int howMany, String path, String[] rescorerParams, Long contextUserID) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany) throws TasteException {
        return this.mostSimilarItems(new long[]{itemID}, howMany);
    }

    public float[] similarityToItem(long toItemID, long ... itemIDs) throws TasteException {
        return this.similarityToItem(toItemID, itemIDs, null);
    }

    /*
     * Exception decompiling
     */
    public float[] similarityToItem(long toItemID, long[] itemIDs, Long contextUserID) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[CASE], 10[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    public List<RecommendedItem> recommendedBecause(long userID, long itemID, int howMany) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void ingest(File file) throws TasteException {
        Reader reader = null;
        try {
            reader = IOUtils.openReaderMaybeDecompressing((File)file);
            this.ingest(reader);
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
        finally {
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ingest(Reader reader) throws TasteException {
        HashMap writersAndConnections = Maps.newHashMapWithExpectedSize((int)this.partitions.size());
        BufferedReader buffered = IOUtils.buffer((Reader)reader);
        try {
            try {
                String line;
                while ((line = buffered.readLine()) != null) {
                    long userID;
                    if (line.isEmpty() || line.charAt(0) == '#') continue;
                    try {
                        userID = Long.parseLong((String)COMMA.split((CharSequence)line).iterator().next());
                    }
                    catch (NoSuchElementException nsee) {
                        throw new TasteException((Throwable)nsee);
                    }
                    catch (NumberFormatException nfe) {
                        throw new TasteException((Throwable)nfe);
                    }
                    int partition = LangUtils.mod((long)userID, (int)this.partitions.size());
                    Pair writerAndConnection = (Pair)writersAndConnections.get(partition);
                    if (writerAndConnection == null) {
                        HttpURLConnection connection = this.buildConnectionToAReplica(partition);
                        Writer writer = IOUtils.buildGZIPWriter((OutputStream)connection.getOutputStream());
                        writerAndConnection = new Pair((Object)writer, (Object)connection);
                        writersAndConnections.put(partition, writerAndConnection);
                    }
                    Writer writer = (Writer)writerAndConnection.getFirst();
                    writer.write(line);
                    writer.write(10);
                }
                for (Pair writerAndConnection : writersAndConnections.values()) {
                    ((Writer)writerAndConnection.getFirst()).close();
                    HttpURLConnection connection = (HttpURLConnection)writerAndConnection.getSecond();
                    if (connection.getResponseCode() == 200) continue;
                    throw new TasteException(connection.getResponseCode() + " " + connection.getResponseMessage());
                }
            }
            finally {
                for (Pair writerAndConnection : writersAndConnections.values()) {
                    Closeables.close((Closeable)((Closeable)writerAndConnection.getFirst()), (boolean)true);
                    ((HttpURLConnection)writerAndConnection.getSecond()).disconnect();
                }
            }
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection buildConnectionToAReplica(int partition) throws TasteException {
        String urlPath = "/ingest";
        TasteException savedException = null;
        for (HostAndPort replica : this.partitions.get(partition)) {
            HttpURLConnection connection = null;
            try {
                connection = this.buildConnectionToReplica(replica, urlPath, "POST", true, true, INGEST_REQUEST_PROPS);
                connection.connect();
                HttpURLConnection httpURLConnection = connection;
                return httpURLConnection;
            }
            catch (IOException ioe) {
                log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, ioe.toString()});
                savedException = new TasteException((Throwable)ioe);
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
        throw savedException;
    }

    @Deprecated
    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        if (alreadyRefreshed != null) {
            log.warn("Ignoring argument {}", alreadyRefreshed);
        }
        this.refresh();
    }

    public void refresh() {
        int numPartitions = this.partitions.size();
        for (int i = 0; i < numPartitions; ++i) {
            this.refreshPartition(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshPartition(int partition) {
        String urlPath = "/refresh";
        for (HostAndPort replica : this.partitions.get(partition)) {
            HttpURLConnection connection = null;
            try {
                connection = this.buildConnectionToReplica(replica, urlPath, "POST");
                if (connection.getResponseCode() == 200) continue;
                log.warn("Unable to refresh partition {} ({} {}); continuing", new Object[]{partition, connection.getResponseCode(), connection.getResponseMessage()});
            }
            catch (IOException ioe) {
                log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, ioe.toString()});
            }
            finally {
                if (connection == null) continue;
                connection.disconnect();
            }
        }
    }

    @Deprecated
    public DataModel getDataModel() {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.recommend(userID, howMany);
    }

    @Deprecated
    public List<RecommendedItem> recommend(long userID, int howMany, boolean considerKnownItems, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.recommend(userID, howMany, considerKnownItems, (String[])null);
    }

    @Deprecated
    public List<RecommendedItem> recommendToMany(long[] userIDs, int howMany, boolean considerKnownItems, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.recommendToMany(userIDs, howMany, considerKnownItems, (String[])null);
    }

    @Deprecated
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, int howMany, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.recommendToAnonymous(itemIDs, howMany);
    }

    @Deprecated
    public List<RecommendedItem> recommendToAnonymous(long[] itemIDs, float[] values, int howMany, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.recommendToAnonymous(itemIDs, values, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostPopularItems(int howMany, IDRescorer rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostPopularItems(howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long itemID, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemID, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer) throws TasteException {
        if (rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, boolean excludeItemIfNotSimilarToAll) throws TasteException {
        if (excludeItemIfNotSimilarToAll) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }

    @Deprecated
    public List<RecommendedItem> mostSimilarItems(long[] itemIDs, int howMany, Rescorer<LongPair> rescorer, boolean excludeItemIfNotSimilarToAll) throws TasteException {
        if (excludeItemIfNotSimilarToAll || rescorer != null) {
            throw new UnsupportedOperationException();
        }
        return this.mostSimilarItems(itemIDs, howMany);
    }

    public boolean isReady() throws TasteException {
        int numPartitions = this.partitions.size();
        for (int i = 0; i < numPartitions; ++i) {
            if (this.isPartitionReady(i)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isPartitionReady(int partition) throws TasteException {
        String urlPath = "/ready";
        TasteException savedException = null;
        Iterator<HostAndPort> i$ = this.partitions.get(partition).iterator();
        while (i$.hasNext()) {
            HostAndPort replica = i$.next();
            HttpURLConnection connection = null;
            connection = this.buildConnectionToReplica(replica, urlPath, "HEAD");
            switch (connection.getResponseCode()) {
                case 200: {
                    boolean bl = true;
                    if (connection == null) return bl;
                    connection.disconnect();
                    return bl;
                }
                case 503: {
                    return false;
                }
            }
            try {
                throw new TasteException(connection.getResponseCode() + " " + connection.getResponseMessage());
            }
            catch (TasteException te) {
                log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, te.toString()});
                savedException = te;
            }
            catch (IOException ioe) {
                log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, ioe.toString()});
                savedException = new TasteException((Throwable)ioe);
            }
        }
        throw savedException;
        catch (Throwable throwable) {
            throw throwable;
        }
    }

    public void await() throws TasteException, InterruptedException {
        while (!this.isReady()) {
            Thread.sleep(1000L);
        }
    }

    public boolean await(long time, TimeUnit unit) throws TasteException, InterruptedException {
        Preconditions.checkArgument((time >= 0L ? 1 : 0) != 0, (String)"time must be positive: {}", (Object[])new Object[]{time});
        Preconditions.checkNotNull((Object)((Object)unit));
        long waitForMS = TimeUnit.MILLISECONDS.convert(time, unit);
        long waitIntervalMS = FastMath.min((long)1000L, (long)waitForMS);
        Stopwatch stopwatch = new Stopwatch().start();
        while (!this.isReady()) {
            if (stopwatch.elapsed(TimeUnit.MILLISECONDS) > waitForMS) {
                return false;
            }
            Thread.sleep(waitIntervalMS);
        }
        return true;
    }

    public FastIDSet getAllUserIDs() throws TasteException {
        FastIDSet result = new FastIDSet();
        int numPartitions = this.partitions.size();
        for (int i = 0; i < numPartitions; ++i) {
            this.getAllIDsFromPartition(i, true, result);
        }
        return result;
    }

    public FastIDSet getAllItemIDs() throws TasteException {
        FastIDSet result = new FastIDSet();
        int numPartitions = this.partitions.size();
        for (int i = 0; i < numPartitions; ++i) {
            this.getAllIDsFromPartition(i, false, result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void getAllIDsFromPartition(int partition, boolean user, FastIDSet result) throws TasteException {
        String urlPath = '/' + (user ? "user" : "item") + "/allIDs";
        TasteException savedException = null;
        Iterator<HostAndPort> i$ = this.partitions.get(partition).iterator();
        while (i$.hasNext()) {
            HostAndPort replica = i$.next();
            HttpURLConnection connection = null;
            try {
                connection = this.buildConnectionToReplica(replica, urlPath, "GET");
                switch (connection.getResponseCode()) {
                    case 200: {
                        ClientRecommender.consumeIDs(connection, result);
                        if (connection == null) return;
                        connection.disconnect();
                        return;
                    }
                    case 503: {
                        throw new NotReadyException();
                    }
                    default: {
                        throw new TasteException(connection.getResponseCode() + " " + connection.getResponseMessage());
                    }
                }
            }
            catch (TasteException te) {
                log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, te.toString()});
                savedException = te;
                if (connection == null) continue;
                connection.disconnect();
            }
            catch (IOException ioe) {
                try {
                    log.info("Can't access {} at {}: ({})", new Object[]{urlPath, replica, ioe.toString()});
                    savedException = new TasteException((Throwable)ioe);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (connection == null) continue;
                    connection.disconnect();
                }
            }
        }
        throw savedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void consumeIDs(HttpURLConnection connection, FastIDSet result) throws IOException {
        BufferedReader reader = IOUtils.bufferStream((InputStream)connection.getInputStream());
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                result.add(Long.parseLong(line));
            }
        }
        finally {
            Closeables.close((Closeable)reader, (boolean)true);
        }
    }

    public int getNumUserClusters() throws TasteException {
        return this.getNumClusters(true);
    }

    public int getNumItemClusters() throws TasteException {
        return this.getNumClusters(false);
    }

    /*
     * Exception decompiling
     */
    private int getNumClusters(boolean user) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [10[CATCHBLOCK], 6[CASE]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public FastIDSet getUserCluster(int n) throws TasteException {
        return this.getCluster(n, true);
    }

    public FastIDSet getItemCluster(int n) throws TasteException {
        return this.getCluster(n, false);
    }

    /*
     * Exception decompiling
     */
    private FastIDSet getCluster(int n, boolean user) throws TasteException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 4[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void appendCommonQueryParams(int howMany, boolean considerKnownItems, String[] rescorerParams, StringBuilder urlPath) {
        urlPath.append("?howMany=").append(howMany);
        if (considerKnownItems) {
            urlPath.append("&considerKnownItems=true");
        }
        if (rescorerParams != null) {
            for (String rescorerParam : rescorerParams) {
                urlPath.append("&rescorerParams=").append(IOUtils.urlEncode((String)rescorerParam));
            }
        }
    }

    static {
        INGEST_REQUEST_PROPS.put("Content-Type", MediaType.PLAIN_TEXT_UTF_8.toString());
        INGEST_REQUEST_PROPS.put("Content-Encoding", "gzip");
        DESIRED_RESPONSE_CONTENT_TYPE = MediaType.CSV_UTF_8.withoutParameters().toString();
    }
}

