/*
 * Decompiled with CFR 0.152.
 */
package net.myrrix.client.translating;

import com.google.common.base.Charsets;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.myrrix.client.ClientRecommender;
import net.myrrix.client.translating.GenericTranslatedRecommendedItem;
import net.myrrix.client.translating.OneWayMigrator;
import net.myrrix.client.translating.TranslatedRecommendedItem;
import net.myrrix.client.translating.TranslatingRecommender;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.model.MemoryIDMigrator;
import org.apache.mahout.cf.taste.model.IDMigrator;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.common.iterator.FileLineIterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class TranslatingClientRecommender
implements TranslatingRecommender {
    private static final Logger log = LoggerFactory.getLogger(TranslatingClientRecommender.class);
    private static final Splitter COMMA_SPLIT = Splitter.on((char)',');
    private static final Joiner COMMA_JOIN = Joiner.on((char)',');
    private final IDMigrator userTranslator = new OneWayMigrator();
    private final MemoryIDMigrator itemTranslator = new MemoryIDMigrator();
    private final ClientRecommender delegate;

    public TranslatingClientRecommender(ClientRecommender delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<TranslatedRecommendedItem> recommend(String userID, int howMany) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        List<RecommendedItem> originals = this.delegate.recommend(longUserID, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommend(String userID, int howMany, boolean considerKnownItems) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        List<RecommendedItem> originals = this.delegate.recommend(longUserID, howMany, considerKnownItems, null);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendToMany(String[] userIDs, int howMany, boolean considerKnownItems) throws TasteException {
        long[] longUserIDs = new long[userIDs.length];
        for (int i = 0; i < userIDs.length; ++i) {
            longUserIDs[i] = this.userTranslator.toLongID(userIDs[i]);
        }
        List<RecommendedItem> originals = this.delegate.recommendToMany(longUserIDs, howMany, considerKnownItems, null);
        return this.translate(originals);
    }

    @Override
    public float estimatePreference(String userID, String itemID) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long longItemID = this.itemTranslator.toLongID(itemID);
        return this.delegate.estimatePreference(longUserID, longItemID);
    }

    @Override
    public float[] estimatePreferences(String userID, String ... itemIDs) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long[] longItemIDs = new long[itemIDs.length];
        for (int i = 0; i < itemIDs.length; ++i) {
            longItemIDs[i] = this.itemTranslator.toLongID(itemIDs[i]);
        }
        return this.delegate.estimatePreferences(longUserID, longItemIDs);
    }

    @Override
    public void setPreference(String userID, String itemID) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long longItemID = this.itemTranslator.toLongID(itemID);
        this.delegate.setPreference(longUserID, longItemID);
    }

    @Override
    public void setPreference(String userID, String itemID, float value) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long longItemID = this.itemTranslator.toLongID(itemID);
        this.delegate.setPreference(longUserID, longItemID, value);
    }

    @Override
    public void removePreference(String userID, String itemID) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long longItemID = this.itemTranslator.toLongID(itemID);
        this.delegate.removePreference(longUserID, longItemID);
    }

    @Override
    public void removePreference(String userID, String itemID, float value) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long longItemID = this.itemTranslator.toLongID(itemID);
        this.delegate.removePreference(longUserID, longItemID, value);
    }

    @Override
    public List<TranslatedRecommendedItem> mostSimilarItems(String itemID, int howMany) throws TasteException {
        long longItemID = this.itemTranslator.toLongID(itemID);
        List<RecommendedItem> originals = this.delegate.mostSimilarItems(longItemID, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> mostSimilarItems(String[] itemIDs, int howMany) throws TasteException {
        long[] longItemIDs = new long[itemIDs.length];
        for (int i = 0; i < itemIDs.length; ++i) {
            longItemIDs[i] = this.itemTranslator.toLongID(itemIDs[i]);
        }
        List<RecommendedItem> originals = this.delegate.mostSimilarItems(longItemIDs, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendedBecause(String userID, String itemID, int howMany) throws TasteException {
        long longUserID = this.userTranslator.toLongID(userID);
        long longItemID = this.itemTranslator.toLongID(itemID);
        List<RecommendedItem> originals = this.delegate.recommendedBecause(longUserID, longItemID, howMany);
        return this.translate(originals);
    }

    @Override
    public List<TranslatedRecommendedItem> recommendToAnonymous(String[] itemIDs, int howMany) throws TasteException {
        long[] longItemIDs = new long[itemIDs.length];
        for (int i = 0; i < itemIDs.length; ++i) {
            longItemIDs[i] = this.itemTranslator.toLongID(itemIDs[i]);
        }
        List<RecommendedItem> originals = this.delegate.recommendToAnonymous(longItemIDs, howMany);
        return this.translate(originals);
    }

    @Override
    public void ingest(Reader reader) throws TasteException {
        File tempFile = null;
        try {
            tempFile = this.copyAndTranslateToTempFile(reader);
            this.delegate.ingest(tempFile);
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
        finally {
            if (tempFile != null && tempFile.exists() && !tempFile.delete()) {
                log.warn("Could not delete {}", (Object)tempFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyAndTranslateToTempFile(Reader reader) throws IOException {
        File tempFile = File.createTempFile("myrrix-", ".csv");
        tempFile.deleteOnExit();
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(tempFile), Charsets.UTF_8);
        BufferedReader buffered = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        try {
            String line;
            while ((line = buffered.readLine()) != null) {
                String translatedLine;
                Iterator it = COMMA_SPLIT.split((CharSequence)line).iterator();
                String userIDString = (String)it.next();
                String itemIDString = (String)it.next();
                long longUserID = this.userTranslator.toLongID(userIDString);
                long longItemID = this.itemTranslator.toLongID(itemIDString);
                if (it.hasNext()) {
                    String valueString = (String)it.next();
                    translatedLine = COMMA_JOIN.join((Object)longUserID, (Object)longItemID, new Object[]{valueString});
                } else {
                    translatedLine = COMMA_JOIN.join((Object)longUserID, (Object)longItemID, new Object[0]);
                }
                out.write(translatedLine + '\n');
            }
            ((Writer)out).flush();
        }
        finally {
            Closeables.closeQuietly((Closeable)out);
        }
        return tempFile;
    }

    @Override
    public void ingest(File file) throws TasteException {
        FileReader reader = null;
        try {
            reader = new FileReader(file);
            this.ingest(reader);
        }
        catch (IOException ioe) {
            try {
                throw new TasteException((Throwable)ioe);
            }
            catch (Throwable throwable) {
                Closeables.closeQuietly(reader);
                throw throwable;
            }
        }
        Closeables.closeQuietly((Closeable)reader);
    }

    @Override
    public void addItemIDs(Iterable<String> ids) {
        this.itemTranslator.initialize(ids);
    }

    @Override
    public void addItemIDs(File idFile) throws TasteException {
        try {
            this.addItemIDs((Iterable<String>)new FileLineIterable(idFile));
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
    }

    private List<TranslatedRecommendedItem> translate(Collection<RecommendedItem> originals) {
        ArrayList translated = Lists.newArrayListWithCapacity((int)originals.size());
        for (RecommendedItem original : originals) {
            long id = original.getItemID();
            String untranslation = this.itemTranslator.toStringID(id);
            String translatedItemID = untranslation == null ? String.valueOf(id) : untranslation;
            translated.add(new GenericTranslatedRecommendedItem(translatedItemID, original.getValue()));
        }
        return translated;
    }
}

